/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.schema.adapter;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.ValueObject;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.ld.schema.adapter.LdValueAdapter;
import jakarta.json.Json;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;

public class ValueObjectAdapter
implements LdValueAdapter<JsonValue, JsonValue> {
    protected final LdTerm type;

    public ValueObjectAdapter() {
        this(null);
    }

    public ValueObjectAdapter(LdTerm type) {
        this.type = type;
    }

    @Override
    public JsonValue read(JsonValue value) {
        if (!ValueObject.isValueObject((JsonValue)value)) {
            throw new IllegalArgumentException();
        }
        if (this.type == null) {
            return (JsonValue)value.asJsonObject().get((Object)"@value");
        }
        JsonValue valueType = (JsonValue)value.asJsonObject().get((Object)"@type");
        if (JsonUtils.isNotString((JsonValue)valueType)) {
            throw new IllegalArgumentException("The value object @type is not JSON string but [" + value.asJsonObject().get((Object)"@type") + "].");
        }
        if (this.type.uri().equalsIgnoreCase(((JsonString)valueType).getString())) {
            return (JsonValue)value.asJsonObject().get((Object)"@value");
        }
        throw new IllegalArgumentException("The value object @type is not [" + this.type.uri() + "] but [" + value.asJsonObject().get((Object)"@type") + "].");
    }

    @Override
    public JsonValue write(JsonValue value) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (this.type != null) {
            builder.add("@type", this.type.uri());
        }
        builder.add("@value", value);
        return builder.build();
    }
}

