/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.signature;

import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.ld.signature.KeyGenError;
import com.apicatalog.ld.signature.LinkedDataSuiteError;
import com.apicatalog.ld.signature.SigningError;
import com.apicatalog.ld.signature.VerificationError;
import com.apicatalog.ld.signature.algorithm.CanonicalizationAlgorithm;
import com.apicatalog.ld.signature.algorithm.DigestAlgorithm;
import com.apicatalog.ld.signature.algorithm.SignatureAlgorithm;
import com.apicatalog.ld.signature.key.KeyPair;
import jakarta.json.JsonStructure;

public class CryptoSuite
implements CanonicalizationAlgorithm,
DigestAlgorithm,
SignatureAlgorithm {
    protected final LdTerm id;
    protected final CanonicalizationAlgorithm canonicalization;
    protected final DigestAlgorithm digester;
    protected final SignatureAlgorithm signer;

    public CryptoSuite(LdTerm id, CanonicalizationAlgorithm canonicalization, DigestAlgorithm digester, SignatureAlgorithm signer) {
        this.id = id;
        this.canonicalization = canonicalization;
        this.digester = digester;
        this.signer = signer;
    }

    @Override
    public void verify(byte[] publicKey, byte[] signature, byte[] data) throws VerificationError {
        this.signer.verify(publicKey, signature, data);
    }

    @Override
    public byte[] sign(byte[] privateKey, byte[] data) throws SigningError {
        return this.signer.sign(privateKey, data);
    }

    @Override
    public byte[] digest(byte[] data) throws LinkedDataSuiteError {
        return this.digester.digest(data);
    }

    @Override
    public byte[] canonicalize(JsonStructure document) throws LinkedDataSuiteError {
        return this.canonicalization.canonicalize(document);
    }

    @Override
    public KeyPair keygen(int length) throws KeyGenError {
        return this.signer.keygen(length);
    }

    public LdTerm getId() {
        return this.id;
    }
}

