/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.signature;

import com.apicatalog.ld.signature.CryptoSuite;
import com.apicatalog.ld.signature.KeyGenError;
import com.apicatalog.ld.signature.LinkedDataSuiteError;
import com.apicatalog.ld.signature.SigningError;
import com.apicatalog.ld.signature.VerificationError;
import com.apicatalog.ld.signature.key.KeyPair;
import com.apicatalog.ld.signature.key.VerificationKey;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import java.net.URI;
import java.util.Objects;

public class LinkedDataSignature {
    private final CryptoSuite suite;

    public LinkedDataSignature(CryptoSuite suite) {
        this.suite = suite;
    }

    public void verify(JsonObject document, JsonObject unsignedProof, VerificationKey verificationKey, byte[] signature) throws VerificationError {
        Objects.requireNonNull(verificationKey);
        Objects.requireNonNull(verificationKey.publicKey());
        Objects.requireNonNull(signature);
        try {
            byte[] computeSignature = this.hashCode((JsonStructure)document, unsignedProof);
            this.suite.verify(verificationKey.publicKey(), signature, computeSignature);
        }
        catch (LinkedDataSuiteError e) {
            throw new VerificationError(VerificationError.Code.InvalidSignature, (Throwable)e);
        }
    }

    public byte[] sign(JsonObject document, KeyPair keyPair, JsonObject proof) throws SigningError {
        try {
            byte[] documentHashCode = this.hashCode((JsonStructure)document, proof);
            return this.suite.sign(keyPair.privateKey(), documentHashCode);
        }
        catch (LinkedDataSuiteError e) {
            throw new SigningError(SigningError.Code.Internal, (Throwable)e);
        }
    }

    byte[] hashCode(JsonStructure document, JsonObject proof) throws LinkedDataSuiteError {
        byte[] proofHash = this.suite.digest(this.suite.canonicalize((JsonStructure)proof));
        byte[] documentHash = this.suite.digest(this.suite.canonicalize(document));
        byte[] result = new byte[proofHash.length + documentHash.length];
        System.arraycopy(proofHash, 0, result, 0, proofHash.length);
        System.arraycopy(documentHash, 0, result, proofHash.length, documentHash.length);
        return result;
    }

    public KeyPair keygen(URI id, int length) throws KeyGenError {
        return this.suite.keygen(length);
    }
}

