/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.signature.method;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.LdProperty;
import com.apicatalog.ld.signature.SignatureSuite;
import com.apicatalog.ld.signature.method.MethodResolver;
import com.apicatalog.ld.signature.method.VerificationMethod;
import com.apicatalog.vc.VcTag;
import jakarta.json.JsonArray;
import jakarta.json.JsonValue;
import java.net.URI;

public class HttpMethodResolver
implements MethodResolver {
    @Override
    public VerificationMethod resolve(URI id, DocumentLoader loader, SignatureSuite suite) throws DocumentError {
        LdProperty property = suite.getSchema().tagged(VcTag.VerificationMethod.name());
        try {
            JsonArray document = JsonLd.expand((URI)id).loader(loader).context(suite.getContext()).get();
            for (JsonValue method : document) {
                if (!JsonUtils.isObject((JsonValue)method)) continue;
                return (VerificationMethod)property.read(method);
            }
        }
        catch (JsonLdError e) {
            throw new DocumentError(e, DocumentError.ErrorType.Invalid, property.term());
        }
        throw new DocumentError(DocumentError.ErrorType.Unknown, property.term());
    }

    @Override
    public boolean isAccepted(URI id) {
        return "http".equalsIgnoreCase(id.getScheme()) || "https".equalsIgnoreCase(id.getScheme());
    }
}

