/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.signature.primitive;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.ld.signature.LinkedDataSuiteError;
import com.apicatalog.ld.signature.algorithm.CanonicalizationAlgorithm;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.io.RdfWriter;
import com.apicatalog.rdf.io.error.RdfWriterException;
import com.apicatalog.rdf.io.error.UnsupportedContentException;
import io.setl.rdf.normalization.RdfNormalize;
import jakarta.json.JsonStructure;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class Urdna2015
implements CanonicalizationAlgorithm {
    @Override
    public byte[] canonicalize(JsonStructure document) throws LinkedDataSuiteError {
        try {
            RdfDataset dataset = JsonLd.toRdf((Document)JsonDocument.of((JsonStructure)document)).get();
            RdfDataset canonical = RdfNormalize.normalize((RdfDataset)dataset);
            StringWriter writer = new StringWriter();
            RdfWriter rdfWriter = Rdf.createWriter((MediaType)MediaType.N_QUADS, (Writer)writer);
            rdfWriter.write(canonical);
            return writer.toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (JsonLdError | RdfWriterException | UnsupportedContentException | IOException e) {
            throw new LinkedDataSuiteError(LinkedDataSuiteError.Code.Canonicalization, e);
        }
    }
}

