/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.ld.signature.proof;

import com.apicatalog.jsonld.JsonLdReader;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.vc.VcVocab;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Collection;

public final class EmbeddedProof {
    protected EmbeddedProof() {
    }

    public static final JsonObject addProof(JsonObject document, JsonObject proof) {
        JsonValue propertyValue = (JsonValue)document.get((Object)VcVocab.PROOF.uri());
        return Json.createObjectBuilder((JsonObject)document).add(VcVocab.PROOF.uri(), (propertyValue != null ? Json.createArrayBuilder((JsonArray)JsonUtils.toJsonArray((JsonValue)propertyValue)) : Json.createArrayBuilder()).add((JsonValue)proof)).build();
    }

    public static Collection<JsonValue> assertProof(JsonObject document) throws DocumentError {
        Collection<JsonValue> proofs = JsonLdReader.getObjects(document, VcVocab.PROOF.uri());
        if (proofs == null || proofs.size() == 0) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.PROOF);
        }
        return proofs;
    }

    public static JsonObject removeProof(JsonObject document) {
        return Json.createObjectBuilder((JsonObject)document).remove(VcVocab.PROOF.uri()).build();
    }
}

