/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc;

import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.signature.KeyGenError;
import com.apicatalog.ld.signature.LinkedDataSignature;
import com.apicatalog.ld.signature.SignatureSuite;
import com.apicatalog.ld.signature.SignatureSuiteMapper;
import com.apicatalog.ld.signature.SignatureSuiteProvider;
import com.apicatalog.ld.signature.SigningError;
import com.apicatalog.ld.signature.VerificationError;
import com.apicatalog.ld.signature.key.KeyPair;
import com.apicatalog.ld.signature.proof.ProofOptions;
import com.apicatalog.vc.processor.Issuer;
import com.apicatalog.vc.processor.KeysGenerator;
import com.apicatalog.vc.processor.Verifier;
import jakarta.json.JsonObject;
import java.net.URI;

public final class Vc {
    public static Verifier verify(URI location, SignatureSuiteProvider suiteProvider) throws DocumentError, VerificationError {
        return new Verifier(location, suiteProvider);
    }

    public static Verifier verify(URI location, SignatureSuite suite) throws DocumentError, VerificationError {
        return new Verifier(location, (SignatureSuiteProvider)new SignatureSuiteMapper().add(suite));
    }

    public static Verifier verify(JsonObject document, SignatureSuiteProvider suiteProvider) throws DocumentError, VerificationError {
        return new Verifier(document, suiteProvider);
    }

    public static Verifier verify(JsonObject document, SignatureSuite suite) throws DocumentError, VerificationError {
        return new Verifier(document, (SignatureSuiteProvider)new SignatureSuiteMapper().add(suite));
    }

    public static Issuer sign(URI documentLocation, KeyPair keyPair, ProofOptions options) throws DocumentError, SigningError {
        return new Issuer(documentLocation, keyPair, options);
    }

    public static Issuer sign(JsonObject document, KeyPair keyPair, ProofOptions options) throws DocumentError, SigningError {
        return new Issuer(document, keyPair, options);
    }

    public static KeysGenerator generateKeysfinal(SignatureSuite signatureSuite) throws KeyGenError {
        if (signatureSuite == null) {
            throw new IllegalArgumentException("The signatureSuite parameter must not be null.");
        }
        return new KeysGenerator(new LinkedDataSignature(signatureSuite.getCryptoSuite()));
    }
}

