/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.integrity;

import com.apicatalog.ld.schema.LdProperty;
import com.apicatalog.ld.schema.LdSchema;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.multibase.Multibase;
import com.apicatalog.multicodec.Multicodec;
import com.apicatalog.vc.VcSchema;
import com.apicatalog.vc.integrity.DataIntegrityKeysAdapter;
import java.time.Instant;
import java.util.function.Predicate;

public final class DataIntegrity {
    public static final String SEC_VOCAB = "https://w3id.org/security#";
    public static final LdTerm TYPE = LdTerm.create("DataIntegrityProof", "https://w3id.org/security#");
    public static final LdTerm CREATED = LdTerm.create("created", "http://purl.org/dc/terms/");
    public static final LdTerm PURPOSE = LdTerm.create("proofPurpose", "https://w3id.org/security#");
    public static final LdTerm VERIFICATION_METHOD = LdTerm.create("verificationMethod", "https://w3id.org/security#");
    public static final LdTerm PROOF_VALUE = LdTerm.create("proofValue", "https://w3id.org/security#");
    public static final LdTerm DOMAIN = LdTerm.create("domain", "https://w3id.org/security#");
    public static final LdTerm CHALLENGE = LdTerm.create("challenge", "https://w3id.org/security#");
    public static final LdTerm CONTROLLER = LdTerm.create("controller", "https://w3id.org/security#");
    public static final LdTerm MULTIBASE_PUB_KEY = LdTerm.create("publicKeyMultibase", "https://w3id.org/security#");
    public static final LdTerm MULTIBASE_PRIV_KEY = LdTerm.create("privateKeyMultibase", "https://w3id.org/security#");

    private DataIntegrity() {
    }

    public static final LdProperty<byte[]> getPublicKey(Multibase.Algorithm encoding, Multicodec.Codec codec, Predicate<byte[]> predicate) {
        return LdSchema.property(MULTIBASE_PUB_KEY, LdSchema.multibase(encoding, codec)).test(predicate);
    }

    public static final LdProperty<byte[]> getPrivateKey(Multibase.Algorithm encoding, Multicodec.Codec codec, Predicate<byte[]> predicate) {
        return LdSchema.property(MULTIBASE_PRIV_KEY, LdSchema.multibase(encoding, codec)).test(predicate);
    }

    public static final LdSchema getKeyPair(LdTerm verificationType, LdProperty<byte[]> publicKey, LdProperty<byte[]> privateKey) {
        return new LdSchema(LdSchema.object(LdSchema.id().required(), LdSchema.type(verificationType), LdSchema.property(CONTROLLER, LdSchema.link()), publicKey, privateKey));
    }

    public static final LdSchema getVerificationKey(LdTerm verificationType, LdProperty<byte[]> publicKey) {
        return new LdSchema(LdSchema.object(LdSchema.id().required(), LdSchema.type(verificationType), LdSchema.property(CONTROLLER, LdSchema.link()), publicKey));
    }

    public static final LdSchema getProof(LdTerm proofType, Multibase.Algorithm proofValueEncoding, Predicate<byte[]> proofValuePredicate, LdSchema method) {
        return VcSchema.proof(LdSchema.type(proofType).required(), LdSchema.property(CREATED, LdSchema.xsdDateTime()).test(created -> Instant.now().isAfter((Instant)created)).required(), LdSchema.property(PURPOSE, LdSchema.link()).required(), VcSchema.verificationMethod(VERIFICATION_METHOD, method.map(new DataIntegrityKeysAdapter())).required(), LdSchema.property(DOMAIN, LdSchema.string()).test((domain, params) -> !params.containsKey(DOMAIN.name()) || params.get(DOMAIN.name()).equals(domain)), LdSchema.property(CHALLENGE, LdSchema.string()), VcSchema.proofValue(PROOF_VALUE, LdSchema.multibase(proofValueEncoding)).test(proofValuePredicate).required());
    }
}

