/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.integrity;

import com.apicatalog.ld.schema.LdObject;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.ld.schema.adapter.LdValueAdapter;
import com.apicatalog.ld.signature.key.VerificationKey;
import com.apicatalog.ld.signature.method.VerificationMethod;
import com.apicatalog.vc.integrity.DataIntegrity;
import com.apicatalog.vc.integrity.DataIntegrityKeyPair;
import java.net.URI;
import java.util.LinkedHashMap;

public class DataIntegrityKeysAdapter
implements LdValueAdapter<LdObject, VerificationMethod> {
    @Override
    public VerificationMethod read(LdObject object) {
        URI id = (URI)object.value(LdTerm.ID);
        URI type = (URI)object.value(LdTerm.TYPE);
        URI controller = (URI)object.value(DataIntegrity.CONTROLLER);
        byte[] publicKey = (byte[])object.value(DataIntegrity.MULTIBASE_PUB_KEY);
        byte[] privateKey = (byte[])object.value(DataIntegrity.MULTIBASE_PRIV_KEY);
        return new DataIntegrityKeyPair(id, type, controller, publicKey, privateKey);
    }

    @Override
    public LdObject write(VerificationMethod method) {
        VerificationKey key;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (method.id() != null) {
            result.put(LdTerm.ID.uri(), method.id());
        }
        if (method.type() != null) {
            result.put(LdTerm.TYPE.uri(), method.type());
        }
        if (method.controller() != null) {
            result.put(DataIntegrity.CONTROLLER.uri(), method.controller());
        }
        if (method instanceof VerificationKey && (key = (VerificationKey)method).publicKey() != null) {
            result.put(DataIntegrity.MULTIBASE_PUB_KEY.uri(), key.publicKey());
        }
        return new LdObject(result);
    }
}

