/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.integrity;

import com.apicatalog.ld.schema.LdObject;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.ld.signature.SignatureSuite;
import com.apicatalog.ld.signature.method.VerificationMethod;
import com.apicatalog.ld.signature.proof.ProofOptions;
import com.apicatalog.vc.integrity.DataIntegrity;
import java.net.URI;
import java.time.Instant;
import java.util.LinkedHashMap;

public class DataIntegrityProofOptions
implements ProofOptions {
    protected final SignatureSuite suite;
    protected URI type;
    protected URI purpose;
    protected VerificationMethod method;
    protected Instant created;
    protected String domain;
    protected String challenge;

    public DataIntegrityProofOptions(SignatureSuite suite) {
        this.suite = suite;
        this.type = URI.create(suite.getId().uri());
    }

    @Override
    public SignatureSuite getSuite() {
        return this.suite;
    }

    @Override
    public LdObject toUnsignedProof() {
        LinkedHashMap<String, Object> proof = new LinkedHashMap<String, Object>();
        proof.put(LdTerm.TYPE.uri(), this.type);
        proof.put(DataIntegrity.CREATED.uri(), this.created);
        proof.put(DataIntegrity.PURPOSE.uri(), this.purpose);
        proof.put(DataIntegrity.VERIFICATION_METHOD.uri(), this.method);
        proof.put(DataIntegrity.DOMAIN.uri(), this.domain);
        proof.put(DataIntegrity.CHALLENGE.uri(), this.challenge);
        return new LdObject(proof);
    }

    public DataIntegrityProofOptions verificationMethod(VerificationMethod verificationMethod) {
        this.method = verificationMethod;
        return this;
    }

    public DataIntegrityProofOptions purpose(URI purpose) {
        this.purpose = purpose;
        return this;
    }

    public DataIntegrityProofOptions created(Instant created) {
        this.created = created;
        return this;
    }

    public DataIntegrityProofOptions domain(String domain) {
        this.domain = domain;
        return this;
    }

    public DataIntegrityProofOptions challenge(String challenge) {
        this.challenge = challenge;
        return this;
    }
}

