/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.loader;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.vc.Vc;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class StaticContextLoader
implements DocumentLoader {
    protected static Map<String, Document> staticCache = new HashMap<String, Document>();
    protected final DocumentLoader defaultLoader;

    protected static JsonDocument get(String name) {
        JsonDocument jsonDocument;
        block8: {
            InputStream is = Vc.class.getResourceAsStream(name);
            try {
                jsonDocument = JsonDocument.of((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonLdError | IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            is.close();
        }
        return jsonDocument;
    }

    public StaticContextLoader(DocumentLoader defaultLoader) {
        this.defaultLoader = defaultLoader;
    }

    public Document loadDocument(URI url, DocumentLoaderOptions options) throws JsonLdError {
        Document document;
        if (staticCache.containsKey(url.toString()) && (document = staticCache.get(url.toString())) != null) {
            return document;
        }
        return this.defaultLoader.loadDocument(url, options);
    }

    static {
        staticCache.put("https://www.w3.org/2018/credentials/examples/v1", (Document)StaticContextLoader.get("2018-credentials-examples-v1.jsonld"));
        staticCache.put("https://www.w3.org/2018/credentials/v1", (Document)StaticContextLoader.get("2018-credentials-v1.jsonld"));
        staticCache.put("https://w3id.org/security/suites/ed25519-2020/v1", (Document)StaticContextLoader.get("security-suites-ed25519-2020-v1.jsonld"));
        staticCache.put("https://www.w3.org/ns/odrl.jsonld", (Document)StaticContextLoader.get("odrl.jsonld"));
        staticCache.put("https://www.w3.org/ns/did/v1", (Document)StaticContextLoader.get("did-v1.jsonld"));
    }
}

