/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.processor;

import com.apicatalog.jsonld.InvalidJsonLdValue;
import com.apicatalog.jsonld.JsonLdReader;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.processor.Verifiable;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Instant;
import java.util.Map;

class Credential
implements Verifiable {
    protected URI id;
    protected URI issuer;
    protected Instant issuance;
    protected Instant issued;
    protected Instant expiration;
    protected Instant validUntil;
    protected Instant validFrom;
    protected JsonValue status;
    protected JsonValue subject;
    protected Map<String, JsonValue> extensions;

    protected Credential() {
    }

    public static boolean isCredential(JsonValue document) {
        if (document == null) {
            throw new IllegalArgumentException("The 'expanded' parameter must not be null.");
        }
        return JsonLdReader.isTypeOf(VcVocab.CREDENTIAL_TYPE.uri(), document);
    }

    public static Credential from(JsonObject document) throws DocumentError {
        if (document == null) {
            throw new IllegalArgumentException("The 'document' parameter must not be null.");
        }
        Credential credential = new Credential();
        if (!JsonLdReader.isTypeOf(VcVocab.CREDENTIAL_TYPE.uri(), (JsonValue)document)) {
            if (!JsonLdReader.hasType((JsonValue)document)) {
                throw new DocumentError(DocumentError.ErrorType.Missing, LdTerm.TYPE);
            }
            throw new DocumentError(DocumentError.ErrorType.Unknown, LdTerm.TYPE);
        }
        if (!JsonLdReader.hasPredicate(document, VcVocab.SUBJECT.uri())) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.SUBJECT);
        }
        try {
            credential.id = JsonLdReader.getId((JsonValue)document).orElse(null);
            JsonLdReader.getId((JsonValue)document, VcVocab.SUBJECT.uri()).orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Missing, VcVocab.SUBJECT));
            if (!JsonLdReader.hasPredicate(document, VcVocab.ISSUER.uri())) {
                throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.ISSUER);
            }
            credential.issuer = JsonLdReader.getId((JsonValue)document, VcVocab.ISSUER.uri()).orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.ISSUER));
            credential.issuance = JsonLdReader.getXsdDateTime((JsonValue)document, VcVocab.ISSUANCE_DATE.uri()).orElse(null);
            credential.validFrom = JsonLdReader.getXsdDateTime((JsonValue)document, VcVocab.VALID_FROM.uri()).orElse(null);
            credential.validUntil = JsonLdReader.getXsdDateTime((JsonValue)document, VcVocab.VALID_UNTIL.uri()).orElse(null);
            credential.issued = JsonLdReader.getXsdDateTime((JsonValue)document, VcVocab.ISSUED.uri()).orElse(null);
            credential.expiration = JsonLdReader.getXsdDateTime((JsonValue)document, VcVocab.EXPIRATION_DATE.uri()).orElse(null);
        }
        catch (InvalidJsonLdValue e) {
            if ("@id".equals(e.getProperty())) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, LdTerm.ID);
            }
            throw new DocumentError(DocumentError.ErrorType.Invalid, LdTerm.create(e.getProperty().substring("https://www.w3.org/2018/credentials#".length()), "https://www.w3.org/2018/credentials#"));
        }
        JsonLdReader.getObjects(document, VcVocab.STATUS.uri()).stream().findFirst().ifPresent(s -> {
            credential.status = s;
        });
        return credential;
    }

    @Override
    public URI getId() {
        return this.id;
    }

    public URI getIssuer() {
        return this.issuer;
    }

    public Instant getIssuanceDate() {
        return this.issuance;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public Instant getIssued() {
        return this.issued;
    }

    public Instant getValidFrom() {
        return this.validFrom;
    }

    public Instant getValidUntil() {
        return this.validUntil;
    }

    public boolean isExpired() {
        return this.expiration != null && this.expiration.isBefore(Instant.now()) || this.validUntil != null && this.validUntil.isBefore(Instant.now());
    }

    public JsonValue getStatus() {
        return this.status;
    }

    public JsonValue getSubject() {
        return this.subject;
    }

    @Override
    public boolean isCredential() {
        return true;
    }

    @Override
    public Credential asCredential() {
        return this;
    }

    public Map<String, JsonValue> getExtensions() {
        return this.extensions;
    }
}

