/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.processor;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdReader;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.loader.SchemeRouter;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.LdProperty;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.ld.signature.LinkedDataSignature;
import com.apicatalog.ld.signature.SigningError;
import com.apicatalog.ld.signature.key.KeyPair;
import com.apicatalog.ld.signature.proof.EmbeddedProof;
import com.apicatalog.ld.signature.proof.ProofOptions;
import com.apicatalog.vc.VcTag;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.loader.StaticContextLoader;
import com.apicatalog.vc.processor.Processor;
import com.apicatalog.vc.processor.Verifiable;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public final class Issuer
extends Processor<Issuer> {
    private final URI location;
    private final JsonObject document;
    private final KeyPair keyPair;
    protected final ProofOptions options;

    public Issuer(URI location, KeyPair keyPair, ProofOptions options) {
        this.location = location;
        this.document = null;
        this.keyPair = keyPair;
        this.options = options;
    }

    public Issuer(JsonObject document, KeyPair keyPair, ProofOptions options) {
        this.document = document;
        this.location = null;
        this.keyPair = keyPair;
        this.options = options;
    }

    public JsonObject getExpanded() throws SigningError, DocumentError {
        if (this.loader == null) {
            this.loader = SchemeRouter.defaultInstance();
        }
        if (this.bundledContexts) {
            this.loader = new StaticContextLoader(this.loader);
        }
        if (this.document != null && this.keyPair != null) {
            return this.sign(this.document, this.keyPair, this.options);
        }
        if (this.location != null && this.keyPair != null) {
            return this.sign(this.location, this.keyPair, this.options);
        }
        throw new IllegalStateException();
    }

    public JsonObject getCompacted(URI contextLocation) throws SigningError, DocumentError {
        JsonObject signed = this.getExpanded();
        try {
            return JsonLd.compact((Document)JsonDocument.of((JsonStructure)signed), (URI)contextLocation).loader(this.loader).get();
        }
        catch (JsonLdError e) {
            this.failWithJsonLd(e);
            throw new DocumentError(e, DocumentError.ErrorType.Invalid, new LdTerm[0]);
        }
    }

    public JsonObject getCompacted() throws SigningError, DocumentError {
        JsonArray context = Json.createArrayBuilder().add("https://www.w3.org/2018/credentials/v1").add("https://w3id.org/security/suites/ed25519-2020/v1").build();
        return this.getCompacted((JsonStructure)context);
    }

    JsonObject getCompacted(JsonStructure context) throws SigningError, DocumentError {
        JsonObject signed = this.getExpanded();
        try {
            return JsonLd.compact((Document)JsonDocument.of((JsonStructure)signed), (Document)JsonDocument.of((JsonStructure)context)).loader(this.loader).get();
        }
        catch (JsonLdError e) {
            this.failWithJsonLd(e);
            throw new DocumentError(e, DocumentError.ErrorType.Invalid, new LdTerm[0]);
        }
    }

    final JsonObject sign(URI documentLocation, KeyPair keyPair, ProofOptions options) throws DocumentError, SigningError {
        try {
            JsonArray expanded = JsonLd.expand((URI)documentLocation).loader(this.loader).base(this.base).get();
            return this.sign(expanded, keyPair, options);
        }
        catch (JsonLdError e) {
            this.failWithJsonLd(e);
            throw new DocumentError(e, DocumentError.ErrorType.Invalid, new LdTerm[0]);
        }
    }

    final JsonObject sign(JsonObject document, KeyPair keyPair, ProofOptions options) throws DocumentError, SigningError {
        try {
            JsonArray expanded = JsonLd.expand((Document)JsonDocument.of((JsonStructure)document)).loader(this.loader).base(this.base).get();
            return this.sign(expanded, keyPair, options);
        }
        catch (JsonLdError e) {
            this.failWithJsonLd(e);
            throw new DocumentError(e, DocumentError.ErrorType.Invalid, new LdTerm[0]);
        }
    }

    final JsonObject sign(JsonArray expanded, KeyPair keyPair, ProofOptions options) throws SigningError, DocumentError {
        JsonObject object = JsonLdReader.findFirstObject((JsonValue)expanded).orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Invalid, new LdTerm[0]));
        Verifiable verifiable = Issuer.get(object);
        this.validate(verifiable);
        if (options.getSuite() == null) {
            throw new SigningError(SigningError.Code.UnsupportedCryptoSuite);
        }
        if (verifiable.isCredential() && verifiable.asCredential().getIssuanceDate() == null) {
            Instant issuanceDate = Instant.now().truncatedTo(ChronoUnit.SECONDS);
            object = Json.createObjectBuilder((JsonObject)object).add(VcVocab.ISSUANCE_DATE.uri(), issuanceDate.toString()).build();
        }
        JsonObject data = EmbeddedProof.removeProof(object);
        LinkedDataSignature ldSignature = new LinkedDataSignature(options.getSuite().getCryptoSuite());
        JsonObject proof = options.getSuite().getSchema().write(options.toUnsignedProof());
        LdProperty proofValueProperty = options.getSuite().getSchema().tagged(VcTag.ProofValue.name());
        byte[] signature = ldSignature.sign(data, keyPair, proof);
        JsonValue proofValue = proofValueProperty.write(signature);
        proof = Json.createObjectBuilder((JsonObject)proof).add(proofValueProperty.term().uri(), Json.createArrayBuilder().add(proofValue)).build();
        return EmbeddedProof.addProof(object, proof);
    }

    final void validate(Verifiable verifiable) throws SigningError, DocumentError {
        if (verifiable.isCredential()) {
            if (verifiable.asCredential().isExpired()) {
                throw new SigningError(SigningError.Code.Expired);
            }
            super.validateData(verifiable.asCredential());
        }
    }
}

