/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.processor;

import com.apicatalog.jsonld.InvalidJsonLdValue;
import com.apicatalog.jsonld.JsonLdReader;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.processor.Verifiable;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

class Presentation
implements Verifiable {
    protected URI id;
    protected URI holder;
    protected Collection<JsonObject> credentials;

    protected Presentation() {
    }

    public static boolean isPresentation(JsonValue document) {
        if (document == null) {
            throw new IllegalArgumentException("The 'document' parameter must not be null.");
        }
        return JsonLdReader.isTypeOf(VcVocab.PRESENTATION_TYPE.uri(), document);
    }

    public static Presentation from(JsonObject document) throws DocumentError {
        if (document == null) {
            throw new IllegalArgumentException("The 'document' parameter must not be null.");
        }
        Presentation presentation = new Presentation();
        if (!JsonLdReader.isTypeOf(VcVocab.PRESENTATION_TYPE.uri(), (JsonValue)document)) {
            if (!JsonLdReader.hasType((JsonValue)document)) {
                throw new DocumentError(DocumentError.ErrorType.Missing, LdTerm.TYPE);
            }
            throw new DocumentError(DocumentError.ErrorType.Unknown, LdTerm.TYPE);
        }
        try {
            presentation.id = JsonLdReader.getId((JsonValue)document).orElse(null);
            presentation.holder = JsonLdReader.getId((JsonValue)document, VcVocab.HOLDER.uri()).orElse(null);
        }
        catch (InvalidJsonLdValue e) {
            if ("@id".equals(e.getProperty())) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, LdTerm.ID);
            }
            throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.HOLDER);
        }
        presentation.credentials = new ArrayList<JsonObject>();
        for (JsonValue credential : JsonLdReader.getObjects(document, VcVocab.VERIFIABLE_CREDENTIALS.uri())) {
            if (JsonUtils.isNotObject((JsonValue)credential)) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.VERIFIABLE_CREDENTIALS);
            }
            presentation.credentials.add(credential.asJsonObject());
        }
        return presentation;
    }

    @Override
    public boolean isPresentation() {
        return true;
    }

    @Override
    public Presentation asPresentation() {
        return this;
    }

    @Override
    public URI getId() {
        return this.id;
    }

    public Collection<JsonObject> getCredentials() {
        return this.credentials;
    }

    public URI getHolder() {
        return this.holder;
    }
}

