/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.processor;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdReader;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.processor.Credential;
import com.apicatalog.vc.processor.Presentation;
import com.apicatalog.vc.processor.SubjectValidator;
import com.apicatalog.vc.processor.Verifiable;
import com.apicatalog.vc.status.StatusPropertiesValidator;
import com.apicatalog.vc.status.StatusValidator;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.net.URI;

abstract class Processor<T extends Processor<?>> {
    protected DocumentLoader loader = null;
    protected boolean bundledContexts = true;
    protected URI base = null;
    protected StatusValidator statusValidator = new StatusPropertiesValidator();
    protected SubjectValidator subjectValidator = null;

    protected Processor() {
    }

    public T loader(DocumentLoader loader) {
        this.loader = loader;
        return (T)this;
    }

    public T useBundledContexts(boolean enable) {
        this.bundledContexts = enable;
        return (T)this;
    }

    public T base(URI base) {
        this.base = base;
        return (T)this;
    }

    public T statusValidator(StatusValidator statusValidator) {
        this.statusValidator = statusValidator;
        return (T)this;
    }

    public T subjectValidator(SubjectValidator subjectValidator) {
        this.subjectValidator = subjectValidator;
        return (T)this;
    }

    protected static Verifiable get(JsonObject expanded) throws DocumentError {
        if (Credential.isCredential((JsonValue)expanded)) {
            return Credential.from(expanded);
        }
        if (Presentation.isPresentation((JsonValue)expanded)) {
            return Presentation.from(expanded);
        }
        if (!JsonLdReader.hasType((JsonValue)expanded)) {
            throw new DocumentError(DocumentError.ErrorType.Missing, LdTerm.TYPE);
        }
        throw new DocumentError(DocumentError.ErrorType.Unknown, LdTerm.TYPE);
    }

    protected void failWithJsonLd(JsonLdError e) throws DocumentError {
        if (JsonLdErrorCode.LOADING_DOCUMENT_FAILED == e.getCode()) {
            throw new DocumentError(e, DocumentError.ErrorType.Invalid, new LdTerm[0]);
        }
        if (JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED == e.getCode()) {
            throw new DocumentError(e, DocumentError.ErrorType.Invalid, new LdTerm[0]);
        }
    }

    protected void validateData(Credential credential) throws DocumentError {
        if (credential.getIssuanceDate() == null && credential.getValidFrom() == null && credential.getIssued() == null) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.ISSUANCE_DATE);
        }
        if (this.statusValidator != null && JsonUtils.isNotNull((JsonValue)credential.getStatus())) {
            this.statusValidator.verify(credential.getStatus());
        }
        if (this.statusValidator != null && JsonUtils.isNotNull((JsonValue)credential.getSubject())) {
            this.statusValidator.verify(credential.getSubject());
        }
    }
}

