/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.processor;

import com.apicatalog.jsonld.InvalidJsonLdValue;
import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdReader;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.SchemeRouter;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.LdObject;
import com.apicatalog.ld.schema.LdProperty;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.ld.signature.LinkedDataSignature;
import com.apicatalog.ld.signature.SignatureSuite;
import com.apicatalog.ld.signature.SignatureSuiteProvider;
import com.apicatalog.ld.signature.VerificationError;
import com.apicatalog.ld.signature.key.VerificationKey;
import com.apicatalog.ld.signature.method.DidUrlMethodResolver;
import com.apicatalog.ld.signature.method.HttpMethodResolver;
import com.apicatalog.ld.signature.method.MethodResolver;
import com.apicatalog.ld.signature.method.VerificationMethod;
import com.apicatalog.ld.signature.proof.EmbeddedProof;
import com.apicatalog.vc.VcTag;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.loader.StaticContextLoader;
import com.apicatalog.vc.processor.Credential;
import com.apicatalog.vc.processor.Processor;
import com.apicatalog.vc.processor.Verifiable;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;

public final class Verifier
extends Processor<Verifier> {
    final SignatureSuiteProvider suiteProvider;
    private final URI location;
    private final JsonObject document;
    private final Map<String, Object> params;
    private Collection<MethodResolver> methodResolvers;

    public Verifier(URI location, SignatureSuiteProvider suiteProvider) {
        this.location = location;
        this.document = null;
        this.suiteProvider = suiteProvider;
        this.methodResolvers = Verifier.defaultResolvers();
        this.params = new LinkedHashMap<String, Object>(10);
    }

    public Verifier(JsonObject document, SignatureSuiteProvider suiteProvider) {
        this.document = document;
        this.location = null;
        this.suiteProvider = suiteProvider;
        this.methodResolvers = Verifier.defaultResolvers();
        this.params = new LinkedHashMap<String, Object>(10);
    }

    public static final Collection<MethodResolver> defaultResolvers() {
        LinkedHashSet<MethodResolver> resolvers = new LinkedHashSet<MethodResolver>();
        resolvers.add(new DidUrlMethodResolver());
        resolvers.add(new HttpMethodResolver());
        return resolvers;
    }

    public Verifier methodResolvers(Collection<MethodResolver> resolvers) {
        this.methodResolvers = resolvers;
        return this;
    }

    public Verifier param(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public void isValid() throws VerificationError, DocumentError {
        if (this.loader == null) {
            this.loader = SchemeRouter.defaultInstance();
        }
        if (this.bundledContexts) {
            this.loader = new StaticContextLoader(this.loader);
        }
        if (this.document != null) {
            this.verify(this.document);
            return;
        }
        if (this.location != null) {
            this.verify(this.location);
            return;
        }
        throw new IllegalStateException();
    }

    private void verify(URI location) throws VerificationError, DocumentError {
        try {
            JsonArray expanded = JsonLd.expand((URI)location).loader(this.loader).base(this.base).get();
            this.verifyExpanded(expanded);
        }
        catch (JsonLdError e) {
            this.failWithJsonLd(e);
            throw new DocumentError(e, DocumentError.ErrorType.Invalid, new LdTerm[0]);
        }
    }

    private void verify(JsonObject document) throws VerificationError, DocumentError {
        try {
            JsonArray expanded = JsonLd.expand((Document)JsonDocument.of((JsonStructure)document)).loader(this.loader).base(this.base).get();
            this.verifyExpanded(expanded);
        }
        catch (JsonLdError e) {
            this.failWithJsonLd(e);
            throw new DocumentError(e, DocumentError.ErrorType.Invalid, new LdTerm[0]);
        }
    }

    private void verifyExpanded(JsonArray expanded) throws VerificationError, DocumentError {
        if (expanded == null || expanded.isEmpty()) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, new LdTerm[0]);
        }
        for (JsonValue item : expanded) {
            if (JsonUtils.isNotObject((JsonValue)item)) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, new LdTerm[0]);
            }
            this.verifyExpanded(item.asJsonObject());
        }
    }

    private void verifyExpanded(JsonObject expanded) throws VerificationError, DocumentError {
        Verifiable veri1fiable = Verifier.get(expanded);
        if (veri1fiable.isCredential()) {
            this.validate(veri1fiable.asCredential());
            this.verifyProofs(expanded);
        } else if (veri1fiable.isPresentation()) {
            this.verifyProofs(expanded);
            for (JsonObject expandedCredential : veri1fiable.asPresentation().getCredentials()) {
                Verifiable credential = Verifier.get(expandedCredential);
                if (!credential.isCredential()) {
                    throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.VERIFIABLE_CREDENTIALS, LdTerm.TYPE);
                }
                this.validate(credential.asCredential());
                this.verifyProofs(expandedCredential);
            }
        } else {
            throw new DocumentError(DocumentError.ErrorType.Unknown, LdTerm.TYPE);
        }
    }

    private void verifyProofs(JsonObject expanded) throws VerificationError, DocumentError {
        Collection<JsonValue> proofs = EmbeddedProof.assertProof(expanded);
        JsonObject data = EmbeddedProof.removeProof(expanded);
        for (JsonValue embeddedProof : proofs) {
            if (JsonUtils.isNotObject((JsonValue)embeddedProof)) {
                throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.PROOF);
            }
            JsonObject proofObject = embeddedProof.asJsonObject();
            Collection<String> proofType = JsonLdReader.getType(proofObject);
            if (proofType == null || proofType.isEmpty()) {
                throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.PROOF, LdTerm.TYPE);
            }
            SignatureSuite signatureSuite = proofType.stream().filter(this.suiteProvider::isSupported).findFirst().map(this.suiteProvider::find).orElseThrow(() -> new VerificationError(VerificationError.Code.UnsupportedCryptoSuite));
            if (signatureSuite.getSchema() == null) {
                throw new IllegalStateException("The suite [" + signatureSuite.getId() + "] does not provide proof schema.");
            }
            LdProperty proofValueProperty = signatureSuite.getSchema().tagged(VcTag.ProofValue.name());
            if (proofValueProperty == null) {
                throw new IllegalStateException("The proof schema does not define the proof value.");
            }
            LdObject proof = signatureSuite.getSchema().read(proofObject);
            signatureSuite.getSchema().validate(proof, this.params);
            if (!proof.contains(proofValueProperty.term())) {
                throw new DocumentError(DocumentError.ErrorType.Missing, proofValueProperty.term());
            }
            byte[] proofValue = (byte[])proof.value(proofValueProperty.term());
            if (proofValue == null || proofValue.length == 0) {
                throw new DocumentError(DocumentError.ErrorType.Missing, proofValueProperty.term());
            }
            LdProperty<VerificationMethod> methodProperty = signatureSuite.getSchema().tagged(VcTag.VerificationMethod.name());
            if (methodProperty == null) {
                throw new IllegalStateException("The proof schema does not define a verification method.");
            }
            VerificationMethod verificationMethod = this.getMethod(methodProperty, proofObject, signatureSuite).orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Missing, methodProperty.term()));
            if (!(verificationMethod instanceof VerificationKey)) {
                throw new DocumentError(DocumentError.ErrorType.Unknown, methodProperty.term());
            }
            JsonObject unsignedProof = Json.createObjectBuilder((JsonObject)proofObject).remove(proofValueProperty.term().uri()).build();
            LinkedDataSignature signature = new LinkedDataSignature(signatureSuite.getCryptoSuite());
            signature.verify(data, unsignedProof, (VerificationKey)verificationMethod, proofValue);
        }
    }

    Optional<VerificationMethod> getMethod(LdProperty<VerificationMethod> property, JsonObject proofObject, SignatureSuite suite) throws VerificationError, DocumentError {
        JsonArray expanded = proofObject.getJsonArray(property.term().uri());
        if (JsonUtils.isNull((JsonValue)expanded) || expanded.isEmpty()) {
            return Optional.empty();
        }
        Iterator iterator = expanded.iterator();
        if (iterator.hasNext()) {
            JsonValue methodValue = (JsonValue)iterator.next();
            if (JsonUtils.isNotObject((JsonValue)methodValue)) {
                throw new IllegalStateException();
            }
            JsonObject methodObject = methodValue.asJsonObject();
            Collection<String> types = JsonLdReader.getType(methodObject);
            if (types == null || types.isEmpty()) {
                return this.resolve(methodObject, suite, property);
            }
            VerificationMethod method = property.read((JsonValue)methodObject);
            if (method instanceof VerificationKey && ((VerificationKey)method).publicKey() != null) {
                return Optional.of(method);
            }
            return this.resolve(method.id(), suite, property);
        }
        return Optional.empty();
    }

    Optional<VerificationMethod> resolve(JsonObject method, SignatureSuite suite, LdProperty<VerificationMethod> property) throws DocumentError, VerificationError {
        try {
            URI id = JsonLdReader.getId((JsonValue)method).orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Missing, property.term()));
            return this.resolve(id, suite, property);
        }
        catch (InvalidJsonLdValue e) {
            throw new DocumentError(e, DocumentError.ErrorType.Invalid, property.term());
        }
    }

    Optional<VerificationMethod> resolve(URI id, SignatureSuite suite, LdProperty<VerificationMethod> property) throws DocumentError {
        if (id == null) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, property.term());
        }
        Optional<MethodResolver> resolver = this.methodResolvers.stream().filter(r -> r.isAccepted(id)).findFirst();
        if (resolver.isPresent()) {
            return Optional.ofNullable(resolver.get().resolve(id, this.loader, suite));
        }
        throw new DocumentError(DocumentError.ErrorType.Unknown, property.term());
    }

    final void validate(Credential credential) throws DocumentError, VerificationError {
        if (credential.isExpired()) {
            throw new VerificationError(VerificationError.Code.Expired);
        }
        if (credential.getIssuanceDate() != null && credential.getIssuanceDate().isAfter(Instant.now()) || credential.getIssued() != null && credential.getIssued().isAfter(Instant.now()) || credential.getValidFrom() != null && credential.getValidFrom().isAfter(Instant.now())) {
            throw new VerificationError(VerificationError.Code.NotValidYet);
        }
        this.validateData(credential);
    }
}

