/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.vc.status;

import com.apicatalog.jsonld.InvalidJsonLdValue;
import com.apicatalog.jsonld.JsonLdReader;
import com.apicatalog.ld.DocumentError;
import com.apicatalog.ld.schema.LdTerm;
import com.apicatalog.vc.VcVocab;
import com.apicatalog.vc.status.StatusValidator;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.Collection;

public class StatusPropertiesValidator
implements StatusValidator {
    protected URI id;
    protected Collection<String> type;

    public static StatusPropertiesValidator from(JsonValue document) throws DocumentError {
        StatusPropertiesValidator status = new StatusPropertiesValidator();
        if (!JsonLdReader.hasType(document)) {
            throw new DocumentError(DocumentError.ErrorType.Missing, VcVocab.STATUS, LdTerm.TYPE);
        }
        try {
            status.type = JsonLdReader.getType(document.asJsonObject());
            status.id = JsonLdReader.getId(document).orElseThrow(() -> new DocumentError(DocumentError.ErrorType.Missing, VcVocab.STATUS, LdTerm.ID));
        }
        catch (InvalidJsonLdValue e) {
            throw new DocumentError(DocumentError.ErrorType.Invalid, VcVocab.STATUS, LdTerm.ID);
        }
        return status;
    }

    public URI getId() {
        return this.id;
    }

    public Collection<String> getType() {
        return this.type;
    }

    @Override
    public void verify(JsonValue status) throws DocumentError, VerifyError {
        StatusPropertiesValidator.from(status);
    }
}

