/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.compaction.UriCompaction;
import com.apicatalog.jsonld.compaction.ValueCompaction;
import com.apicatalog.jsonld.context.ActiveContextBuilder;
import com.apicatalog.jsonld.context.InverseContext;
import com.apicatalog.jsonld.context.InverseContextBuilder;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.context.TermDefinitionBuilder;
import com.apicatalog.jsonld.context.TermSelector;
import com.apicatalog.jsonld.expansion.UriExpansion;
import com.apicatalog.jsonld.expansion.ValueExpansion;
import com.apicatalog.jsonld.lang.DirectionType;
import jakarta.json.JsonObject;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class ActiveContext {
    private final Map<String, TermDefinition> terms;
    private URI baseUri;
    private URI baseUrl;
    private InverseContext inverseContext;
    private ActiveContext previousContext;
    private String vocabularyMapping;
    private String defaultLanguage;
    private DirectionType defaultBaseDirection;
    private final JsonLdOptions options;

    public ActiveContext(JsonLdOptions options) {
        this(null, null, null, options);
    }

    public ActiveContext(URI baseUri, URI baseUrl, JsonLdOptions options) {
        this(baseUri, baseUrl, null, options);
    }

    public ActiveContext(URI baseUri, URI baseUrl, ActiveContext previousContext, JsonLdOptions options) {
        this.baseUri = baseUri;
        this.baseUrl = baseUrl;
        this.previousContext = previousContext;
        this.terms = new LinkedHashMap<String, TermDefinition>();
        this.options = options;
    }

    public ActiveContext(ActiveContext origin) {
        this.terms = new LinkedHashMap<String, TermDefinition>(origin.terms);
        this.baseUri = origin.baseUri;
        this.baseUrl = origin.baseUrl;
        this.inverseContext = origin.inverseContext;
        this.previousContext = origin.previousContext;
        this.vocabularyMapping = origin.vocabularyMapping;
        this.defaultLanguage = origin.defaultLanguage;
        this.defaultBaseDirection = origin.defaultBaseDirection;
        this.options = origin.options;
    }

    public void createInverseContext() {
        this.inverseContext = InverseContextBuilder.with(this).build();
    }

    public boolean containsTerm(String term) {
        return this.terms.containsKey(term);
    }

    public boolean containsProtectedTerm() {
        return this.terms.values().stream().anyMatch(TermDefinition::isProtected);
    }

    protected Optional<TermDefinition> removeTerm(String term) {
        if (this.terms.containsKey(term)) {
            return Optional.of(this.terms.remove(term));
        }
        return Optional.empty();
    }

    public Optional<TermDefinition> getTerm(String value) {
        return Optional.ofNullable(this.terms.get(value));
    }

    public DirectionType getDefaultBaseDirection() {
        return this.defaultBaseDirection;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public String getVocabularyMapping() {
        return this.vocabularyMapping;
    }

    public boolean inMode(JsonLdVersion version) {
        return this.options.getProcessingMode() != null && this.options.getProcessingMode().equals((Object)version);
    }

    public ActiveContext getPreviousContext() {
        return this.previousContext;
    }

    public URI getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    public InverseContext getInverseContext() {
        return this.inverseContext;
    }

    public Map<String, TermDefinition> getTermsMapping() {
        return this.terms;
    }

    public Collection<String> getTerms() {
        return this.terms.keySet();
    }

    public ActiveContextBuilder newContext() {
        return ActiveContextBuilder.with(this);
    }

    public UriExpansion uriExpansion() {
        return UriExpansion.with(this);
    }

    public ValueExpansion valueExpansion() {
        return ValueExpansion.with(this);
    }

    public UriCompaction uriCompaction() {
        return UriCompaction.with(this);
    }

    public ValueCompaction valueCompaction() {
        return ValueCompaction.with(this);
    }

    public TermDefinitionBuilder newTerm(JsonObject localContext, Map<String, Boolean> defined) {
        return TermDefinitionBuilder.with(this, localContext, defined);
    }

    public TermSelector termSelector(String variable, Collection<String> containerMapping, String typeLanguage) {
        return TermSelector.with(this, variable, containerMapping, typeLanguage);
    }

    public JsonLdOptions getOptions() {
        return this.options;
    }

    protected void setDefaultBaseDirection(DirectionType defaultBaseDirection) {
        this.defaultBaseDirection = defaultBaseDirection;
    }

    protected void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    protected void setVocabularyMapping(String vocabularyMapping) {
        this.vocabularyMapping = vocabularyMapping;
    }

    protected void setBaseUrl(URI baseUrl) {
        this.baseUrl = baseUrl;
    }

    protected void setPreviousContext(ActiveContext previousContext) {
        this.previousContext = previousContext;
    }

    protected void setInverseContext(InverseContext inverseContext) {
        this.inverseContext = inverseContext;
    }

    protected void setTerm(String term, TermDefinition definition) {
        this.terms.put(term, definition);
    }
}

