/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class InverseContext {
    private final Map<String, Map<String, Map<String, Map<String, String>>>> context = new LinkedHashMap<String, Map<String, Map<String, Map<String, String>>>>();

    private void set(String variable, String container, String type, String key, String value) {
        this.context.computeIfAbsent(variable, x -> new LinkedHashMap()).computeIfAbsent(container, x -> new LinkedHashMap()).computeIfAbsent(type, x -> new LinkedHashMap()).put(key, value);
    }

    public boolean doesNotContain(String variable, String container, String type) {
        return !this.context.containsKey(variable) || !this.context.get(variable).containsKey(container) || !this.context.get(variable).get(container).containsKey(type);
    }

    public boolean doesNotContain(String variable, String container, String type, String key) {
        return this.doesNotContain(variable, container, type) || !this.context.get(variable).get(container).get(type).containsKey(key);
    }

    public boolean contains(String variable) {
        return this.context.containsKey(variable);
    }

    public boolean contains(String variable, String container, String type, String key) {
        return this.contains(variable) && this.context.get(variable).containsKey(container) && this.context.get(variable).get(container).containsKey(type) && this.context.get(variable).get(container).get(type).containsKey(key);
    }

    public void setIfAbsent(String variable, String container, String type, String key, String value) {
        if (this.doesNotContain(variable, container, type, key)) {
            this.set(variable, container, type, key, value);
        }
    }

    public Optional<String> get(String variable, String container, String type, String key) {
        if (this.doesNotContain(variable, container, type, key)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.context.get(variable).get(container).get(type).get(key));
    }
}

