/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.uri;

import com.apicatalog.jsonld.uri.UriUtils;
import java.net.URI;
import java.util.ArrayList;

public final class UriResolver {
    private UriResolver() {
    }

    public static final String resolve(URI base, String relative) {
        if (base == null) {
            return relative;
        }
        URI components = UriUtils.create(relative);
        String basePath = base.getPath();
        String baseAuthority = base.getAuthority();
        String componentPath = components.getPath();
        if (baseAuthority == null && base.getSchemeSpecificPart().startsWith("///")) {
            baseAuthority = "";
        }
        if (basePath == null && base.getSchemeSpecificPart() != null) {
            basePath = base.getSchemeSpecificPart();
        }
        if (componentPath == null && components.getSchemeSpecificPart() != null) {
            componentPath = components.getSchemeSpecificPart();
        }
        String scheme = null;
        String authority = null;
        String path = null;
        String query = null;
        if (components.getScheme() != null && !components.getScheme().isBlank()) {
            scheme = components.getScheme();
            authority = components.getAuthority();
            path = UriResolver.removeDotSegments(componentPath);
            query = components.getQuery();
        } else {
            if (components.getAuthority() != null && !components.getAuthority().isBlank()) {
                authority = components.getAuthority();
                path = UriResolver.removeDotSegments(componentPath);
                query = components.getQuery();
            } else {
                if (componentPath != null && !componentPath.isBlank()) {
                    path = componentPath.startsWith("/") ? UriResolver.removeDotSegments(componentPath) : (basePath != null && !basePath.isBlank() ? UriResolver.removeDotSegments(UriResolver.merge(basePath, componentPath)) : "/".concat(UriResolver.removeDotSegments(componentPath)));
                    query = components.getQuery();
                } else {
                    path = basePath;
                    query = UriUtils.isDefined(components.getQuery()) ? components.getQuery() : base.getQuery();
                }
                authority = baseAuthority;
            }
            scheme = base.getScheme();
        }
        return UriUtils.recompose(scheme, authority, path, query, components.getFragment());
    }

    private static final String removeDotSegments(String path) {
        if (UriUtils.isNotDefined(path)) {
            return "";
        }
        String input = path;
        ArrayList<String> output = new ArrayList<String>();
        while (!input.isBlank()) {
            if (input.startsWith("../")) {
                input = input.substring(3);
                continue;
            }
            if (input.startsWith("./")) {
                input = input.substring(2);
                continue;
            }
            if (input.startsWith("/./")) {
                input = "/".concat(input.substring(3));
                continue;
            }
            if ("/.".equals(input)) {
                input = "/";
                continue;
            }
            if (input.startsWith("/../")) {
                input = "/".concat(input.substring(4));
                if (output.isEmpty()) continue;
                output.remove(output.size() - 1);
                continue;
            }
            if ("/..".equals(input)) {
                input = "/";
                if (output.isEmpty()) continue;
                output.remove(output.size() - 1);
                continue;
            }
            if ("..".equals(input) || ".".equals(input)) {
                input = "";
                continue;
            }
            int nextSlashIndex = input.indexOf(47, 1);
            if (nextSlashIndex != -1) {
                output.add(input.substring(0, nextSlashIndex));
                input = input.substring(nextSlashIndex);
                continue;
            }
            output.add(input);
            input = "";
        }
        return String.join((CharSequence)"", output);
    }

    private static final String merge(String basePath, String path) {
        if (UriUtils.isNotDefined(basePath)) {
            return "/".concat(path);
        }
        int rightMostSlash = basePath.lastIndexOf(47);
        if (rightMostSlash == -1) {
            return path;
        }
        return basePath.substring(0, rightMostSlash + 1).concat(path);
    }
}

