/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.deseralization;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.deseralization.ObjectToRdf;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.uri.UriValidationPolicy;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfResource;
import com.apicatalog.rdf.RdfTriple;
import com.apicatalog.rdf.RdfValue;
import jakarta.json.JsonArray;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

final class ListToRdf {
    private JsonArray list;
    private List<RdfTriple> triples;
    private NodeMap nodeMap;
    private JsonLdOptions.RdfDirection rdfDirection;
    private UriValidationPolicy uriValidation;

    private ListToRdf(JsonArray list, List<RdfTriple> triples, NodeMap nodeMap) {
        this.list = list;
        this.triples = triples;
        this.nodeMap = nodeMap;
        this.rdfDirection = null;
        this.uriValidation = JsonLdOptions.DEFAULT_URI_VALIDATION;
    }

    public static final ListToRdf with(JsonArray list, List<RdfTriple> triples, NodeMap nodeMap) {
        return new ListToRdf(list, triples, nodeMap);
    }

    public ListToRdf rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public RdfValue build() throws JsonLdError {
        if (JsonUtils.isEmptyArray((JsonValue)this.list)) {
            return Rdf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        }
        String[] bnodes = new String[this.list.size()];
        IntStream.range(0, bnodes.length).forEach(i -> {
            bnodes[i] = this.nodeMap.createIdentifier();
        });
        int index = 0;
        for (JsonValue item : this.list) {
            String subject = bnodes[index];
            ArrayList<RdfTriple> embeddedTriples = new ArrayList<RdfTriple>();
            ObjectToRdf.with(item.asJsonObject(), embeddedTriples, this.nodeMap).rdfDirection(this.rdfDirection).uriValidation(this.uriValidation).build().ifPresent(object -> this.triples.add(Rdf.createTriple(Rdf.createBlankNode(subject), Rdf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#first"), object)));
            RdfResource rest = ++index < bnodes.length ? Rdf.createBlankNode(bnodes[index]) : Rdf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            this.triples.add(Rdf.createTriple(Rdf.createBlankNode(subject), Rdf.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest"), rest));
            this.triples.addAll(embeddedTriples);
        }
        return Rdf.createBlankNode(bnodes[0]);
    }

    @Deprecated
    public ListToRdf uriValidation(boolean enabled) {
        return this.uriValidation(enabled ? UriValidationPolicy.Full : UriValidationPolicy.SchemeOnly);
    }

    public ListToRdf uriValidation(UriValidationPolicy uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }
}

