/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.apicatalog.rdf.lang;

public final class RdfConstants {

    public static final String DIRECTION = "http://www.w3.org/1999/02/22-rdf-syntax-ns#direction";

    public static final String TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";

    public static final String NIL = "http://www.w3.org/1999/02/22-rdf-syntax-ns#nil";

    public static final String FIRST = "http://www.w3.org/1999/02/22-rdf-syntax-ns#first";

    public static final String REST = "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest";

    public static final String JSON = "http://www.w3.org/1999/02/22-rdf-syntax-ns#JSON";

    public static final String LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    
    public static final String DIR_LANG_STRING = "http://www.w3.org/1999/02/22-rdf-syntax-ns#dirLangString";

    public static final String LIST = "http://www.w3.org/1999/02/22-rdf-syntax-ns#List";

    public static final String VALUE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#value";

    public static final String LANGUAGE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#language";

    public static final String I18N_BASE = "https://www.w3.org/ns/i18n#";

    private RdfConstants() {
    }

}