/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.canon;

import java.util.LinkedHashMap;
import java.util.Map;

public class IdentifierIssuer {
    private final Map<String, String> existing;
    private final String prefix;
    private int counter;

    public IdentifierIssuer(String prefix) {
        this(prefix, new LinkedHashMap<String, String>(), 0);
    }

    public IdentifierIssuer(String prefix, Map<String, String> mapping, int counter) {
        this.prefix = prefix;
        this.existing = mapping;
        this.counter = counter;
    }

    public void assign(IdentifierIssuer other) {
        this.existing.forEach((k, v) -> other.getId((String)k));
    }

    public IdentifierIssuer copy() {
        IdentifierIssuer newIssuer = new IdentifierIssuer(this.prefix);
        newIssuer.existing.putAll(this.existing);
        newIssuer.counter = this.counter;
        return newIssuer;
    }

    private String getForBlank(String value) {
        if (this.hasId(value)) {
            return this.getId(value);
        }
        return value;
    }

    public String getId(String id) {
        return this.existing.computeIfAbsent(id, k -> this.prefix + this.counter++);
    }

    public String getIfExists(String value) {
        return value != null ? this.getForBlank(value) : value;
    }

    public boolean hasId(String id) {
        return this.existing.containsKey(id);
    }

    public Map<String, String> mapping() {
        return this.existing;
    }
}

