/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.canon;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class Permutator
implements Iterator<String[]> {
    private final String[] array;
    private final short[] count;
    private boolean nextExists = true;
    private int state = 0;

    Permutator(String[] input) {
        this.array = (String[])input.clone();
        this.count = new short[this.array.length];
    }

    @Override
    public boolean hasNext() {
        return this.nextExists;
    }

    @Override
    public String[] next() {
        if (!this.nextExists) {
            throw new NoSuchElementException();
        }
        String[] output = (String[])this.array.clone();
        while (this.state < this.array.length) {
            if (this.count[this.state] < this.state) {
                if ((this.state & 1) == 0) {
                    this.swap(0, this.state);
                } else {
                    this.swap(this.count[this.state], this.state);
                }
                int n = this.state;
                this.count[n] = (short)(this.count[n] + 1);
                this.state = 0;
                return output;
            }
            this.count[this.state] = 0;
            ++this.state;
        }
        this.nextExists = false;
        return output;
    }

    void swap(int i, int j) {
        String t = this.array[i];
        this.array[i] = this.array[j];
        this.array[j] = t;
    }
}

