/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.canon;

import com.apicatalog.rdf.canon.Blank;
import com.apicatalog.rdf.canon.Quad;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

enum Position {
    SUBJECT('s'){

        @Override
        String get(Quad quad) {
            return quad.subject();
        }

        @Override
        void set(Quad quad, String value, Blank blank) {
            quad.subject = value;
            quad.blankSubject = blank;
        }

        @Override
        public boolean isBlank(Quad quad) {
            return quad.blankSubject != null;
        }
    }
    ,
    OBJECT('o'){

        @Override
        String get(Quad quad) {
            return quad.object();
        }

        @Override
        public boolean isBlank(Quad quad) {
            return quad.blankObject != null;
        }

        @Override
        void set(Quad quad, String value, Blank blank) {
            quad.object = value;
            quad.blankObject = blank;
        }
    }
    ,
    GRAPH('g'){

        @Override
        String get(Quad quad) {
            return quad.graph();
        }

        @Override
        public boolean isBlank(Quad quad) {
            return quad.graph != null;
        }

        @Override
        void set(Quad quad, String value, Blank blank) {
            quad.graph = value;
            quad.blankGraph = blank;
        }
    }
    ,
    PREDICATE('p'){

        @Override
        String get(Quad quad) {
            return quad.predicate;
        }

        @Override
        public boolean isBlank(Quad quad) {
            return false;
        }

        @Override
        void set(Quad quad, String value, Blank blank) {
            assert (blank == null);
            quad.predicate = value;
        }
    };

    public static final Set<Position> CAN_BE_BLANK;
    private final byte tag;

    private Position(char ch) {
        this.tag = (byte)ch;
    }

    abstract String get(Quad var1);

    abstract boolean isBlank(Quad var1);

    abstract void set(Quad var1, String var2, Blank var3);

    public byte tag() {
        return this.tag;
    }

    static {
        CAN_BE_BLANK = Collections.unmodifiableSet(EnumSet.of(SUBJECT, OBJECT, GRAPH));
    }
}

