/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.canon;

import com.apicatalog.rdf.api.RdfConsumerException;
import com.apicatalog.rdf.api.RdfQuadConsumer;
import com.apicatalog.rdf.canon.Blank;
import com.apicatalog.rdf.canon.IdentifierIssuer;
import com.apicatalog.rdf.canon.NDegreeResult;
import com.apicatalog.rdf.canon.Permutator;
import com.apicatalog.rdf.canon.Position;
import com.apicatalog.rdf.canon.Quad;
import com.apicatalog.rdf.canon.QuadComparator;
import com.apicatalog.rdf.canon.RdfCanonTicker;
import com.apicatalog.rdf.nquads.NQuadsWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class RdfCanon
implements RdfQuadConsumer {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String BLANK_A = "_:a";
    private static final String BLANK_Z = "_:z";
    private final Map<String, Collection<Quad>> blankIdToQuadSet;
    private final Map<String, Blank> blankNodes;
    private final IdentifierIssuer canonIssuer = new IdentifierIssuer("_:c14n");
    private final RdfCanonTicker ticker;
    private final Map<String, Set<String>> hashToBlankId = new TreeMap<String, Set<String>>();
    private final Set<Quad> quads;
    private final MessageDigest digest;
    private Set<String> nonNormalized;

    RdfCanon(Map<String, Collection<Quad>> blankIdToQuadSet, Map<String, Blank> resources, MessageDigest digest, Set<Quad> nquads, RdfCanonTicker ticker) {
        this.blankIdToQuadSet = blankIdToQuadSet;
        this.blankNodes = resources;
        this.digest = digest;
        this.quads = nquads;
        this.ticker = ticker;
    }

    public static RdfCanon create(String hashAlgorithm) {
        return RdfCanon.create(hashAlgorithm, RdfCanonTicker.EMPTY);
    }

    public static RdfCanon create(String hashAlgorithm, RdfCanonTicker ticker) {
        try {
            return RdfCanon.create(MessageDigest.getInstance(hashAlgorithm), ticker);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(hashAlgorithm + " is not available", e);
        }
    }

    public static RdfCanon create(MessageDigest digest) {
        return RdfCanon.create(digest, RdfCanonTicker.EMPTY);
    }

    public static RdfCanon create(MessageDigest digest, RdfCanonTicker ticker) {
        return RdfCanon.newInstance(new LinkedHashSet<Quad>(), digest, ticker);
    }

    public void provide(RdfQuadConsumer consumer) throws RdfConsumerException {
        this.ticker.tick();
        this.setNonNormalized();
        this.issueSimpleIds();
        this.issueNDegreeIds();
        this.makeCanonQuads(consumer);
    }

    public Map<String, String> mapping() {
        return this.canonIssuer.mapping();
    }

    public RdfQuadConsumer quad(String subject, String predicate, String object, String datatype, String language, String direction, String graph) {
        Quad quad = new Quad();
        this.setResource(Position.SUBJECT, quad, subject);
        quad.predicate = predicate;
        if (RdfQuadConsumer.isLiteral((String)datatype, (String)language, (String)direction)) {
            quad.object = object;
            quad.datatype = datatype;
            quad.language = language;
            quad.direction = direction;
        } else {
            this.setResource(Position.OBJECT, quad, object);
        }
        this.setResource(Position.GRAPH, quad, graph);
        quad.init();
        this.quads.add(quad);
        return this;
    }

    static RdfCanon newInstance(Set<Quad> nquads, MessageDigest digest, RdfCanonTicker ticker) {
        return new RdfCanon(new HashMap<String, Collection<Quad>>(), new HashMap<String, Blank>(), digest, nquads, ticker);
    }

    String forBlank(Quad q0, String blankNodeId) {
        String subject = q0.subject;
        if (q0.blankSubject != null) {
            subject = subject.equals(blankNodeId) ? BLANK_A : BLANK_Z;
        }
        String object = q0.object;
        if (q0.blankObject != null) {
            object = object.equals(blankNodeId) ? BLANK_A : BLANK_Z;
        }
        String graph = q0.graph;
        if (q0.blankGraph != null) {
            graph = graph.equals(blankNodeId) ? BLANK_A : BLANK_Z;
        }
        return NQuadsWriter.nquad((String)subject, (String)q0.predicate, (String)object, (String)q0.datatype, (String)q0.language, (String)q0.direction, (String)graph);
    }

    void setNonNormalized() {
        this.nonNormalized = new HashSet<String>(this.blankIdToQuadSet.keySet());
    }

    String hashFirstDegree(String blankNodeId) {
        Collection<Quad> related = this.blankIdToQuadSet.get(blankNodeId);
        Object[] nQuads = new String[related.size()];
        int i = 0;
        for (Quad q0 : related) {
            this.ticker.tick();
            nQuads[i] = this.forBlank(q0, blankNodeId);
            ++i;
        }
        Arrays.sort(nQuads);
        this.digest.reset();
        for (Object s : nQuads) {
            this.digest.update(((String)s).getBytes(StandardCharsets.UTF_8));
        }
        return RdfCanon.hex(this.digest.digest());
    }

    void issueSimpleIds() {
        boolean simple = true;
        while (simple) {
            this.ticker.tick();
            simple = false;
            this.hashToBlankId.clear();
            for (String value : this.nonNormalized) {
                String hash = this.hashFirstDegree(value);
                this.hashToBlankId.computeIfAbsent(hash, k -> new HashSet()).add(value);
            }
            Iterator<Map.Entry<String, Set<String>>> iterator = this.hashToBlankId.entrySet().iterator();
            while (iterator.hasNext()) {
                this.ticker.tick();
                Map.Entry<String, Set<String>> entry = iterator.next();
                Set<String> values = entry.getValue();
                if (values.size() != 1) continue;
                String id = values.iterator().next();
                this.canonIssuer.getId(id);
                this.nonNormalized.remove(id);
                iterator.remove();
                simple = true;
            }
        }
    }

    void issueNDegreeIds() {
        for (Map.Entry<String, Set<String>> entry : this.hashToBlankId.entrySet()) {
            ArrayList<NDegreeResult> hashPathList = new ArrayList<NDegreeResult>();
            for (String id : entry.getValue()) {
                this.ticker.tick();
                if (this.canonIssuer.hasId(id)) continue;
                IdentifierIssuer blankIssuer = new IdentifierIssuer("_:b");
                blankIssuer.getId(id);
                NDegreeResult path = this.hashNDegreeQuads(id, blankIssuer);
                hashPathList.add(path);
            }
            hashPathList.sort(Comparator.naturalOrder());
            for (NDegreeResult result : hashPathList) {
                this.ticker.tick();
                result.getIssuer().assign(this.canonIssuer);
            }
        }
    }

    void makeCanonQuads(RdfQuadConsumer consumer) throws RdfConsumerException {
        this.blankNodes.entrySet().forEach(entry -> {
            ((Blank)entry.getValue()).normalized = this.canonIssuer.getIfExists((String)entry.getKey());
        });
        ArrayList<Quad> sorted = new ArrayList<Quad>(this.quads);
        Collections.sort(sorted, QuadComparator.asc());
        for (Quad quad : sorted) {
            consumer.quad(quad.subject(), quad.predicate, quad.object(), quad.datatype, quad.language, quad.direction, quad.graph());
        }
    }

    static String hex(byte[] data) {
        StringBuilder builder = new StringBuilder(data.length * 2);
        for (byte b : data) {
            builder.append(HEX[(b & 0xF0) >> 4]).append(HEX[b & 0xF]);
        }
        return builder.toString();
    }

    NDegreeResult hashNDegreeQuads(String id, IdentifierIssuer issuer) {
        return new HashNDegreeQuads().hash(id, issuer);
    }

    void setResource(Position position, Quad quad, String name) {
        Blank blank = null;
        if (RdfQuadConsumer.isBlank((String)name)) {
            blank = this.blankNodes.computeIfAbsent(name, arg0 -> new Blank());
            this.blankIdToQuadSet.computeIfAbsent(name, k -> new LinkedList()).add(quad);
        }
        position.set(quad, name, blank);
    }

    private class HashNDegreeQuads {
        final StringBuilder dataToHash = new StringBuilder();
        IdentifierIssuer chosenIssuer = null;
        StringBuilder chosenPath = null;

        private HashNDegreeQuads() {
        }

        private void appendToPath(String related, StringBuilder pathBuilder, IdentifierIssuer issuerCopy, List<String> recursionList) {
            if (RdfCanon.this.canonIssuer.hasId(related)) {
                pathBuilder.append(RdfCanon.this.canonIssuer.getId(related));
            } else {
                if (!issuerCopy.hasId(related)) {
                    recursionList.add(related);
                }
                pathBuilder.append(issuerCopy.getId(related));
            }
        }

        private SortedMap<String, Set<String>> createHashToRelated(String id, IdentifierIssuer issuer) {
            TreeMap<String, Set<String>> hashToRelated = new TreeMap<String, Set<String>>();
            Collection refer = (Collection)RdfCanon.this.blankIdToQuadSet.get(id);
            for (Quad quad : refer) {
                RdfCanon.this.ticker.tick();
                for (Position position : Position.CAN_BE_BLANK) {
                    if (!position.isBlank(quad) || id.equals(position.get(quad))) continue;
                    String related = position.get(quad);
                    String hash = this.hashRelatedBlankNode(related, quad, issuer, position);
                    hashToRelated.computeIfAbsent(hash, h -> new HashSet()).add(related);
                }
            }
            return hashToRelated;
        }

        private void doPermutation(String[] permutation, IdentifierIssuer issuer) {
            RdfCanon.this.ticker.tick();
            IdentifierIssuer issuerCopy = issuer.copy();
            StringBuilder pathBuilder = new StringBuilder();
            ArrayList<String> recursionList = new ArrayList<String>();
            for (String relatedId : permutation) {
                RdfCanon.this.ticker.tick();
                this.appendToPath(relatedId, pathBuilder, issuerCopy, recursionList);
                if (this.chosenPath.length() <= 0 || pathBuilder.toString().compareTo(this.chosenPath.toString()) <= 0) continue;
                return;
            }
            for (String related : recursionList) {
                RdfCanon.this.ticker.tick();
                NDegreeResult result = RdfCanon.this.hashNDegreeQuads(related, issuerCopy);
                pathBuilder.append(issuerCopy.getId(related)).append('<').append(result.getHash()).append('>');
                issuerCopy = result.getIssuer();
                if (this.chosenPath.length() <= 0 || pathBuilder.toString().compareTo(this.chosenPath.toString()) <= 0) continue;
                return;
            }
            if (this.chosenPath.length() == 0 || pathBuilder.toString().compareTo(this.chosenPath.toString()) < 0) {
                this.chosenPath.setLength(0);
                this.chosenPath.append((CharSequence)pathBuilder);
                this.chosenIssuer = issuerCopy;
            }
        }

        NDegreeResult hash(String id, IdentifierIssuer defaultIssuer) {
            IdentifierIssuer issuer = defaultIssuer;
            SortedMap<String, Set<String>> hashToRelated = this.createHashToRelated(id, defaultIssuer);
            for (Map.Entry<String, Set<String>> entry : hashToRelated.entrySet()) {
                this.dataToHash.append(entry.getKey());
                this.chosenPath = new StringBuilder();
                this.chosenIssuer = null;
                Permutator permutator = new Permutator(entry.getValue().toArray(new String[entry.getValue().size()]));
                while (permutator.hasNext()) {
                    RdfCanon.this.ticker.tick();
                    this.doPermutation(permutator.next(), issuer);
                }
                this.dataToHash.append((CharSequence)this.chosenPath);
                issuer = this.chosenIssuer;
            }
            RdfCanon.this.digest.reset();
            String hash = RdfCanon.hex(RdfCanon.this.digest.digest(this.dataToHash.toString().getBytes(StandardCharsets.UTF_8)));
            return new NDegreeResult(hash, issuer);
        }

        private String hashRelatedBlankNode(String related, Quad quad, IdentifierIssuer issuer, Position position) {
            String id = RdfCanon.this.canonIssuer.hasId(related) ? RdfCanon.this.canonIssuer.getId(related) : (issuer.hasId(related) ? issuer.getId(related) : RdfCanon.this.hashFirstDegree(related));
            RdfCanon.this.digest.reset();
            RdfCanon.this.digest.update(position.tag());
            if (position != Position.GRAPH) {
                RdfCanon.this.digest.update(NQuadsWriter.resource((String)quad.predicate).getBytes(StandardCharsets.UTF_8));
            }
            RdfCanon.this.digest.update(id.getBytes(StandardCharsets.UTF_8));
            return RdfCanon.hex(RdfCanon.this.digest.digest());
        }
    }
}

