/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.rdf.canon;

import com.apicatalog.rdf.canon.RdfCanonTicker;

public final class RdfCanonTimeTicker
implements RdfCanonTicker {
    private final long maxDurationMillis;
    private long startTimeMillis = 0L;

    public RdfCanonTimeTicker(long maxDurationMillis) {
        if (maxDurationMillis <= 0L) {
            throw new IllegalArgumentException("Maximum duration must be positive.");
        }
        this.maxDurationMillis = maxDurationMillis;
    }

    @Override
    public void tick() throws IllegalStateException {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.startTimeMillis == 0L) {
            this.startTimeMillis = currentTimeMillis;
            return;
        }
        long elapsedMillis = currentTimeMillis - this.startTimeMillis;
        if (elapsedMillis > this.maxDurationMillis) {
            throw new IllegalStateException("Maximum execution time of " + this.maxDurationMillis + " ms exceeded. Elapsed: " + elapsedMillis + " ms.");
        }
    }
}

