/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.source;

import com.apifan.common.random.entity.CurrencyInfo;
import com.apifan.common.random.entity.KChartData;
import com.apifan.common.random.source.NumberSource;
import com.apifan.common.random.util.ResourceUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinancialSource {
    private static final Logger logger = LoggerFactory.getLogger(FinancialSource.class);
    private static final DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static List<String> stockShSzList = Lists.newArrayList();
    private static List<String> stockHkList = Lists.newArrayList();
    private static List<String> stockXsbList = Lists.newArrayList();
    private static List<String> fundsList = Lists.newArrayList();
    private static List<String> currencyList = Lists.newArrayList();
    private static final FinancialSource instance = new FinancialSource();

    private FinancialSource() {
        stockShSzList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("stock-shsz.txt"));
        stockHkList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("stock-hk.txt"));
        stockXsbList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("stock-xsb.txt"));
        fundsList = ResourceUtils.readLines("fund.txt");
        currencyList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("currency.txt"));
    }

    public static FinancialSource getInstance() {
        return instance;
    }

    public String[] randomStock() {
        String stock = ResourceUtils.getRandomString(stockShSzList, 1);
        return StringUtils.isBlank((CharSequence)stock) ? null : stock.split(",");
    }

    public String[] randomHKStock() {
        String stock = ResourceUtils.getRandomString(stockHkList, 1);
        return StringUtils.isBlank((CharSequence)stock) ? null : stock.split(",");
    }

    public String[] randomXsbStock() {
        String stock = ResourceUtils.getRandomString(stockXsbList, 1);
        return StringUtils.isBlank((CharSequence)stock) ? null : stock.split(",");
    }

    public String[] randomFund() {
        String fund = ResourceUtils.getRandomString(fundsList, 1);
        return StringUtils.isNotEmpty((CharSequence)fund) ? fund.split(",") : null;
    }

    public List<KChartData> randomDailyKChartData(double beginPrice, double limitUp, double limitDown, String beginDate, String endDate) {
        LocalDate end;
        LocalDate begin;
        Preconditions.checkArgument((beginPrice > 0.0 ? 1 : 0) != 0, (Object)"\u8d77\u59cb\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0");
        Preconditions.checkArgument((limitUp > 0.0 && limitUp < 1.0 ? 1 : 0) != 0, (Object)"\u5355\u65e5\u6700\u5927\u6da8\u5e45\u4e3a 0~1 \u4e4b\u95f4\u7684\u5c0f\u6570");
        Preconditions.checkArgument((limitDown < 0.0 && limitDown > -1.0 ? 1 : 0) != 0, (Object)"\u5355\u65e5\u6700\u5927\u8dcc\u5e45\u4e3a -1~0 \u4e4b\u95f4\u7684\u5c0f\u6570");
        try {
            begin = LocalDate.parse(beginDate, yyyyMMdd);
        }
        catch (Exception e) {
            logger.error("\u8d77\u59cb\u65e5\u671f\u683c\u5f0f\u6709\u8bef", (Throwable)e);
            throw new IllegalArgumentException("\u8d77\u59cb\u65e5\u671f\u683c\u5f0f\u6709\u8bef:" + beginDate);
        }
        try {
            end = LocalDate.parse(endDate, yyyyMMdd);
        }
        catch (Exception e) {
            logger.error("\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u6709\u8bef", (Throwable)e);
            throw new IllegalArgumentException("\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u6709\u8bef:" + endDate);
        }
        Preconditions.checkArgument((boolean)end.isAfter(begin), (Object)"\u65e5\u671f\u8303\u56f4\u6709\u8bef");
        LocalDate date = begin;
        BigDecimal lastClose = null;
        ArrayList<KChartData> kChartDataList = new ArrayList<KChartData>();
        while (date.isBefore(end) || date.isEqual(end)) {
            KChartData k = new KChartData();
            k.setDate(yyyyMMdd.format(date));
            BigDecimal open = lastClose == null ? BigDecimal.valueOf(beginPrice) : lastClose;
            k.setOpen(open);
            int x = NumberSource.getInstance().randomInt(0, 11);
            if (x % 2 == 0) {
                k.setClose(open.add(BigDecimal.valueOf(NumberSource.getInstance().randomDouble(0.0, open.doubleValue() * limitUp))));
                k.setHigh(k.getClose());
                k.setLow(k.getOpen());
            } else {
                k.setClose(open.subtract(BigDecimal.valueOf(NumberSource.getInstance().randomDouble(0.0, -1.0 * open.doubleValue() * limitDown))));
                k.setHigh(k.getOpen());
                k.setLow(k.getClose());
            }
            lastClose = k.getClose();
            kChartDataList.add(k);
            date = date.plusDays(1L);
        }
        return kChartDataList;
    }

    public CurrencyInfo randomCurrencyInfo() {
        String currency = ResourceUtils.getRandomString(currencyList, 1);
        if (StringUtils.isBlank((CharSequence)currency)) {
            return null;
        }
        String[] tmp = currency.split(",");
        if (tmp.length != 3) {
            return null;
        }
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setRegion(tmp[0]);
        currencyInfo.setName(tmp[1]);
        currencyInfo.setCode(tmp[2]);
        return currencyInfo;
    }
}

