/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.source;

import com.apifan.common.random.entity.EconomicCategory;
import com.apifan.common.random.entity.Poem;
import com.apifan.common.random.source.FinancialSource;
import com.apifan.common.random.util.ResourceUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtherSource {
    private static final Logger logger = LoggerFactory.getLogger(OtherSource.class);
    private static final List<String> plateNumbersList = Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "L", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"});
    private static final List<String> provincePrefixList = Lists.newArrayList((Object[])new String[]{"\u4eac", "\u6d25", "\u5180", "\u664b", "\u8499", "\u8fbd", "\u5409", "\u9ed1", "\u6caa", "\u82cf", "\u6d59", "\u7696", "\u95fd", "\u8d63", "\u9c81", "\u8c6b", "\u9102", "\u6e58", "\u7ca4", "\u6842", "\u743c", "\u6e1d", "\u5ddd", "\u8d35", "\u4e91", "\u85cf", "\u9655", "\u7518", "\u5b81", "\u9752", "\u65b0"});
    private static final List<String> companySuffixList = Lists.newArrayList((Object[])new String[]{"\u80a1\u4efd\u6709\u9650\u516c\u53f8", "\u6709\u9650\u8d23\u4efb\u516c\u53f8"});
    private static final List<String> companyIndustryList = Lists.newArrayList((Object[])new String[]{"\u79d1\u6280", "\u4fe1\u606f", "\u5546\u8d38", "\u8d38\u6613", "\u5b9e\u4e1a", "\u6587\u5316\u4f20\u64ad", "\u6587\u5316\u521b\u610f", "\u5de5\u7a0b", "\u6559\u80b2", "\u53d1\u5c55", "\u54a8\u8be2", "\u8bbe\u8ba1", "\u7f6e\u4e1a", "\u6295\u8d44", "\u4f20\u5a92", "\u670d\u52a1"});
    private static final String ISBN_PREFIX = "978";
    private static final String ISBN_COUNTRY_OR_REGION_CODE = "7";
    private static final List<Integer[]> publisherCodeList = Lists.newArrayList((Object[])new Integer[][]{{5000, 5128}, {5300, 5480}, {5600, 5644}, {80000, 80258}, {80500, 80756}, {81002, 81140}});
    private static List<String> departmentList = Lists.newArrayList();
    private static List<String> chineseNounsList = Lists.newArrayList();
    private static List<String> chineseVerbsList = Lists.newArrayList();
    private static List<String> chineseAdverbsList = Lists.newArrayList();
    private static List<String> chinesePronounsList = Lists.newArrayList();
    private static List<String> chineseConjunctionsList = Lists.newArrayList();
    private static List<String> chineseParticlesList = Lists.newArrayList();
    private static List<String> mobileModelsList = Lists.newArrayList();
    private static List<String> ethnicNamesList = Lists.newArrayList();
    private static List<String> nonsenseList = Lists.newArrayList();
    private static List<String> astonishingPrefixList = Lists.newArrayList();
    private static List<String> sensationalTitlesList = Lists.newArrayList();
    private static final List<EconomicCategory> economicCategoryList = Lists.newArrayList();
    private static List<Poem> tangPoemsList = Lists.newArrayList();
    private static List<String> chineseIdiomsList = Lists.newArrayList();
    private static final OtherSource instance = new OtherSource();

    private OtherSource() {
        chineseNounsList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("common-chinese-nouns.txt"));
        chinesePronounsList = ResourceUtils.readLines("common-chinese-pronouns.txt");
        chineseAdverbsList = ResourceUtils.readLines("common-chinese-adverbs.txt");
        chineseVerbsList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("common-chinese-verbs.txt"));
        chineseConjunctionsList = ResourceUtils.readLines("common-chinese-conjunctions.txt");
        chineseParticlesList = ResourceUtils.readLines("common-chinese-particles.txt");
        departmentList = ResourceUtils.readLines("common-department.txt");
        List<String> economicCategoryLines = ResourceUtils.readLines("national-economic-category.txt");
        if (CollectionUtils.isNotEmpty(economicCategoryLines)) {
            economicCategoryLines.forEach(e -> {
                if (StringUtils.isBlank((CharSequence)e)) {
                    return;
                }
                String[] tmp = e.split(",");
                if (tmp.length == 2) {
                    EconomicCategory ec = new EconomicCategory();
                    ec.setCode(tmp[0]);
                    ec.setName(tmp[1]);
                    economicCategoryList.add(ec);
                }
            });
        }
        mobileModelsList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("mobile-models.txt"));
        ethnicNamesList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("ethnic-cn.txt"));
        nonsenseList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("nonsense.txt"));
        sensationalTitlesList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("sensational-titles.txt"));
        astonishingPrefixList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("astonishing-prefix.txt"));
        chineseIdiomsList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("chinese-idioms.txt"));
        ObjectMapper objectMapper = new ObjectMapper();
        CollectionType poemType = objectMapper.getTypeFactory().constructCollectionType(List.class, Poem.class);
        try {
            tangPoemsList = (List)objectMapper.readValue(ResourceUtils.readString("tang-poems.json"), (JavaType)poemType);
        }
        catch (JsonProcessingException e2) {
            logger.error("\u521d\u59cb\u5316\u6570\u636e\u5f02\u5e38", (Throwable)e2);
        }
    }

    public static OtherSource getInstance() {
        return instance;
    }

    public String randomChinese() {
        String str = "";
        int highCode = RandomUtils.nextInt((int)176, (int)215);
        int lowCode = RandomUtils.nextInt((int)161, (int)254);
        byte[] b = new byte[]{Integer.valueOf(highCode).byteValue(), Integer.valueOf(lowCode).byteValue()};
        try {
            str = new String(b, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u53d1\u751f\u7f16\u7801\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        return str;
    }

    public String randomChinese(int count) {
        if (count < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(this.randomChinese());
        }
        return sb.toString();
    }

    public String randomPlateNumber(boolean isNewEnergyVehicle) {
        int length = 5;
        ArrayList<String> plateNumbers = new ArrayList<String>(length);
        String prefix = ResourceUtils.getRandomElement(provincePrefixList);
        int alphaCnt = RandomUtils.nextInt((int)0, (int)3);
        if (alphaCnt > 0) {
            for (int i = 0; i < alphaCnt; ++i) {
                plateNumbers.add(ResourceUtils.getRandomElement(plateNumbersList));
            }
        }
        int numericCnt = length - alphaCnt;
        for (int i = 0; i < numericCnt; ++i) {
            plateNumbers.add(String.valueOf(RandomUtils.nextInt((int)0, (int)10)));
        }
        Collections.shuffle(plateNumbers);
        String newEnergyVehicleTag = "";
        if (isNewEnergyVehicle) {
            int j = RandomUtils.nextInt((int)0, (int)2);
            newEnergyVehicleTag = j == 0 ? "D" : "F";
        }
        return prefix + ResourceUtils.getRandomElement(plateNumbersList) + newEnergyVehicleTag + Joiner.on((String)"").join(plateNumbers);
    }

    public String randomPlateNumber() {
        return this.randomPlateNumber(false);
    }

    public String randomCompanyName(String province) {
        int length = RandomUtils.nextInt((int)2, (int)7);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)province)) {
            sb.append(province);
        }
        sb.append(this.randomChinese(length));
        sb.append(ResourceUtils.getRandomElement(companyIndustryList));
        sb.append(ResourceUtils.getRandomElement(companySuffixList));
        return sb.toString();
    }

    public String randomCompanyDepartment() {
        return ResourceUtils.getRandomElement(departmentList);
    }

    public String randomChineseSentence() {
        StringBuilder sb = new StringBuilder();
        int r = RandomUtils.nextInt((int)1, (int)11);
        if (r % 2 == 0) {
            sb.append(ResourceUtils.getRandomElement(chinesePronounsList));
        }
        sb.append(ResourceUtils.getRandomElement(chineseNounsList));
        sb.append(ResourceUtils.getRandomElement(chineseAdverbsList));
        sb.append(ResourceUtils.getRandomElement(chineseVerbsList));
        sb.append(ResourceUtils.getRandomElement(chineseNounsList));
        r = RandomUtils.nextInt((int)1, (int)11);
        if (r % 2 == 0) {
            sb.append(ResourceUtils.getRandomElement(chineseNounsList));
        }
        if ((r = RandomUtils.nextInt((int)1, (int)101)) % 2 == 0) {
            r = RandomUtils.nextInt((int)1, (int)11);
            if (r % 2 == 0) {
                sb.append("\uff0c");
            } else {
                sb.append(ResourceUtils.getRandomElement(chineseParticlesList));
                sb.append("\uff1f");
            }
            r = RandomUtils.nextInt((int)1, (int)11);
            if (r % 2 == 0) {
                sb.append(ResourceUtils.getRandomElement(chineseConjunctionsList));
            }
            if ((r = RandomUtils.nextInt((int)1, (int)11)) % 3 == 0) {
                sb.append(ResourceUtils.getRandomElement(chinesePronounsList));
            }
            sb.append(ResourceUtils.getRandomElement(chineseNounsList));
            sb.append(ResourceUtils.getRandomElement(chineseVerbsList));
            sb.append(ResourceUtils.getRandomElement(chineseNounsList));
        }
        sb.append("\u3002");
        return sb.toString();
    }

    public EconomicCategory randomEconomicCategory() {
        return ResourceUtils.getRandomElement(economicCategoryList);
    }

    public String randomEthnicName() {
        return ResourceUtils.getRandomElement(ethnicNamesList);
    }

    public String randomNonsense(String subject, String behavior) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)subject), (Object)"\u4e3b\u8bed\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)behavior), (Object)"\u884c\u4e3a\u4e0d\u80fd\u4e3a\u7a7a");
        String tpl = ResourceUtils.getRandomElement(nonsenseList);
        return tpl.replaceAll("A", subject).replaceAll("B", behavior);
    }

    public String randomNonsenseTitle(String subject, String behavior) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)subject), (Object)"\u4e3b\u8bed\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)behavior), (Object)"\u884c\u4e3a\u4e0d\u80fd\u4e3a\u7a7a");
        String tpl = ResourceUtils.getRandomElement(sensationalTitlesList);
        return ResourceUtils.getRandomElement(astonishingPrefixList) + "\uff01" + tpl.replaceAll("A", subject).replaceAll("B", behavior);
    }

    public String randomISBN(boolean withDelimiter) {
        Integer[] publisherCode = ResourceUtils.getRandomElement(publisherCodeList);
        String publisher = String.valueOf(RandomUtils.nextInt((int)publisherCode[0], (int)(publisherCode[1] + 1)));
        String seq = RandomStringUtils.randomNumeric((int)(8 - publisher.length()));
        ArrayList parts = Lists.newArrayList((Object[])new String[]{ISBN_PREFIX, ISBN_COUNTRY_OR_REGION_CODE, publisher, seq});
        parts.add(OtherSource.getCheckDigit(Joiner.on((String)"").join((Iterable)parts)));
        return Joiner.on((String)(withDelimiter ? "-" : "")).join((Iterable)parts);
    }

    public String randomEAN() {
        String prefix = String.valueOf(RandomUtils.nextInt((int)690, (int)692));
        String manufacturer = RandomStringUtils.randomNumeric((int)4);
        String productCode = RandomStringUtils.randomNumeric((int)5);
        ArrayList parts = Lists.newArrayList((Object[])new String[]{prefix, manufacturer, productCode});
        parts.add(OtherSource.getCheckDigit(Joiner.on((String)"").join((Iterable)parts)));
        return Joiner.on((String)"").join((Iterable)parts);
    }

    public int[] randomRgbColor() {
        return new int[]{RandomUtils.nextInt((int)0, (int)256), RandomUtils.nextInt((int)0, (int)256), RandomUtils.nextInt((int)0, (int)256)};
    }

    public String randomHexColor() {
        int[] color = this.randomRgbColor();
        return String.format("#%02x%02x%02x", color[0], color[1], color[2]).toUpperCase();
    }

    public String[] randomStock() {
        return FinancialSource.getInstance().randomStock();
    }

    public String[] randomFund() {
        return FinancialSource.getInstance().randomFund();
    }

    public String randomMobileModel() {
        return ResourceUtils.getRandomElement(mobileModelsList);
    }

    public Poem randomTangPoem() {
        return ResourceUtils.getRandomElement(tangPoemsList);
    }

    public String randomChineseIdiom() {
        return ResourceUtils.getRandomElement(chineseIdiomsList);
    }

    private static String getCheckDigit(String toCheck) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)toCheck), (Object)"\u5f85\u8ba1\u7b97\u7684\u6570\u5b57\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        int total = 0;
        for (int i = 1; i <= toCheck.length(); ++i) {
            int factor = i % 2 == 0 ? 3 : 1;
            int x = Integer.parseInt(String.valueOf(toCheck.charAt(i - 1)));
            int chk = x * factor;
            total += chk;
        }
        int mod = total % 10;
        int digit = mod == 0 ? 0 : 10 - mod;
        return String.valueOf(digit);
    }
}

