/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.source;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberSource {
    private static final Logger logger = LoggerFactory.getLogger(NumberSource.class);
    private static final NumberSource instance = new NumberSource();

    private NumberSource() {
    }

    public static NumberSource getInstance() {
        return instance;
    }

    public int randomInt() {
        return RandomUtils.nextInt((int)Integer.MIN_VALUE, (int)Integer.MAX_VALUE);
    }

    public int randomInt(int startInclusive, int endExclusive) {
        return RandomUtils.nextInt((int)startInclusive, (int)endExclusive);
    }

    public int[] randomInt(int startInclusive, int endExclusive, int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"\u968f\u673a\u6574\u6570\u4e2a\u6570\u5fc5\u987b\u5927\u4e8e0");
        int[] nums = new int[count];
        for (int i = 0; i < count; ++i) {
            nums[i] = this.randomInt(startInclusive, endExclusive);
        }
        return nums;
    }

    public long randomLong() {
        return RandomUtils.nextLong((long)Long.MIN_VALUE, (long)Long.MAX_VALUE);
    }

    public long randomLong(long startInclusive, long endExclusive) {
        return RandomUtils.nextLong((long)startInclusive, (long)endExclusive);
    }

    public long[] randomLong(long startInclusive, long endExclusive, int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"\u968f\u673a\u957f\u6574\u6570\u4e2a\u6570\u5fc5\u987b\u5927\u4e8e0");
        long[] nums = new long[count];
        for (int i = 0; i < count; ++i) {
            nums[i] = this.randomLong(startInclusive, endExclusive);
        }
        return nums;
    }

    public double randomDouble() {
        return RandomUtils.nextDouble((double)Double.MIN_VALUE, (double)Double.MAX_VALUE);
    }

    public double randomDouble(double startInclusive, double endExclusive) {
        return RandomUtils.nextDouble((double)startInclusive, (double)endExclusive);
    }

    public double[] randomDouble(double startInclusive, double endExclusive, int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"\u968f\u673a\u53cc\u7cbe\u5ea6\u6570\u4e2a\u6570\u5fc5\u987b\u5927\u4e8e0");
        double[] nums = new double[count];
        for (int i = 0; i < count; ++i) {
            nums[i] = this.randomDouble(startInclusive, endExclusive);
        }
        return nums;
    }

    public BigDecimal randomPercent() {
        return BigDecimal.valueOf(RandomUtils.nextDouble((double)1.0E-4, (double)0.9999)).setScale(4, RoundingMode.HALF_UP);
    }
}

