/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.util.pinyin.impl;

import com.apifan.common.random.util.pinyin.PinyinConverter;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pinyin4jConverter
implements PinyinConverter {
    private static final Logger log = LoggerFactory.getLogger(Pinyin4jConverter.class);

    @Override
    public String toPinyin(String src, boolean toLowerCase) {
        char[] chars;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)src), (Object)"\u539f\u59cb\u5b57\u7b26\u4e32\u4e3a\u7a7a");
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        if (toLowerCase) {
            outputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        } else {
            outputFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        }
        ArrayList<String> out = new ArrayList<String>();
        for (char c : chars = src.toCharArray()) {
            try {
                String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)outputFormat);
                if (pinyin.length <= 0) continue;
                out.add(pinyin[0]);
            }
            catch (BadHanyuPinyinOutputFormatCombination e) {
                log.error("\u8f6c\u6362\u62fc\u97f3\u5f02\u5e38", (Throwable)e);
            }
        }
        return Joiner.on((String)"").join(out);
    }
}

