/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.source;

import com.apifan.common.random.entity.GreekAlphabet;
import com.apifan.common.random.entity.Poem;
import com.apifan.common.random.util.JsonUtils;
import com.apifan.common.random.util.ResourceUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageSource {
    private static final Logger logger = LoggerFactory.getLogger(LanguageSource.class);
    private static List<String> chineseNounsList = Lists.newArrayList();
    private static List<String> chineseVerbsList = Lists.newArrayList();
    private static List<String> chineseAdverbsList = Lists.newArrayList();
    private static List<String> chinesePronounsList = Lists.newArrayList();
    private static List<String> chineseConjunctionsList = Lists.newArrayList();
    private static List<String> chineseParticlesList = Lists.newArrayList();
    private static List<String> nonsenseList = Lists.newArrayList();
    private static List<String> astonishingPrefixList = Lists.newArrayList();
    private static List<String> sensationalTitlesList = Lists.newArrayList();
    private static List<Poem> tangPoemsList = Lists.newArrayList();
    private static List<String> chineseIdiomsList = Lists.newArrayList();
    private static List<String> englishWordsList = Lists.newArrayList();
    private static final List<GreekAlphabet> greekAlphabets = Lists.newArrayList();
    private static final LanguageSource instance = new LanguageSource();

    private LanguageSource() {
        chineseNounsList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("common-chinese-nouns.txt"));
        chinesePronounsList = ResourceUtils.readLines("common-chinese-pronouns.txt");
        chineseAdverbsList = ResourceUtils.readLines("common-chinese-adverbs.txt");
        chineseVerbsList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("common-chinese-verbs.txt"));
        chineseConjunctionsList = ResourceUtils.readLines("common-chinese-conjunctions.txt");
        chineseParticlesList = ResourceUtils.readLines("common-chinese-particles.txt");
        nonsenseList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("nonsense.txt"));
        sensationalTitlesList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("sensational-titles.txt"));
        astonishingPrefixList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("astonishing-prefix.txt"));
        chineseIdiomsList = ResourceUtils.base64DecodeLines(ResourceUtils.readLines("chinese-idioms.txt"));
        englishWordsList = ResourceUtils.readLines("word-en.txt");
        try {
            tangPoemsList = JsonUtils.parseObjectList(ResourceUtils.readString("tang-poems.json"), Poem.class);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        greekAlphabets.add(new GreekAlphabet("\u0391", "\u03b1", "alpha"));
        greekAlphabets.add(new GreekAlphabet("\u0392", "\u03b2", "beta"));
        greekAlphabets.add(new GreekAlphabet("\u0393", "\u03b3", "gamma"));
        greekAlphabets.add(new GreekAlphabet("\u0394", "\u03b4", "delta"));
        greekAlphabets.add(new GreekAlphabet("\u0395", "\u03b5", "epsilon"));
        greekAlphabets.add(new GreekAlphabet("\u0396", "\u03b6", "zeta"));
        greekAlphabets.add(new GreekAlphabet("\u0397", "\u03b7", "eta"));
        greekAlphabets.add(new GreekAlphabet("\u0398", "\u03b8", "theta"));
        greekAlphabets.add(new GreekAlphabet("\u0399", "\u03b9", "iota"));
        greekAlphabets.add(new GreekAlphabet("\u039a", "\u03ba", "kappa"));
        greekAlphabets.add(new GreekAlphabet("\u039b", "\u03bb", "lambda"));
        greekAlphabets.add(new GreekAlphabet("\u039c", "\u03bc", "mu"));
        greekAlphabets.add(new GreekAlphabet("\u039d", "\u03bd", "nu"));
        greekAlphabets.add(new GreekAlphabet("\u039e", "\u03be", "xi"));
        greekAlphabets.add(new GreekAlphabet("\u039f", "\u03bf", "omicron"));
        greekAlphabets.add(new GreekAlphabet("\u03a0", "\u03c0", "pi"));
        greekAlphabets.add(new GreekAlphabet("\u03a1", "\u03c1", "rho"));
        greekAlphabets.add(new GreekAlphabet("\u03a3", "\u03c3 (\u03c2)", "sigma"));
        greekAlphabets.add(new GreekAlphabet("\u03a4", "\u03c4", "tau"));
        greekAlphabets.add(new GreekAlphabet("\u03a5", "\u03c5", "upsilon"));
        greekAlphabets.add(new GreekAlphabet("\u03a6", "\u03c6", "phi"));
        greekAlphabets.add(new GreekAlphabet("\u03a7", "\u03c7", "chi"));
        greekAlphabets.add(new GreekAlphabet("\u03a8", "\u03c8", "psi"));
        greekAlphabets.add(new GreekAlphabet("\u03a9", "\u03c9", "omega"));
    }

    public static LanguageSource getInstance() {
        return instance;
    }

    public String randomChinese() {
        String str = "";
        int highCode = RandomUtils.nextInt((int)176, (int)215);
        int lowCode = RandomUtils.nextInt((int)161, (int)254);
        byte[] b = new byte[]{Integer.valueOf(highCode).byteValue(), Integer.valueOf(lowCode).byteValue()};
        try {
            str = new String(b, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u53d1\u751f\u7f16\u7801\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        return str;
    }

    public String randomChinese(int count) {
        if (count < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(this.randomChinese());
        }
        return sb.toString();
    }

    public String randomChineseSentence() {
        StringBuilder sb = new StringBuilder();
        int r = RandomUtils.nextInt((int)1, (int)11);
        if (r % 2 == 0) {
            sb.append(ResourceUtils.getRandomElement(chinesePronounsList));
        }
        sb.append(ResourceUtils.getRandomElement(chineseNounsList));
        sb.append(ResourceUtils.getRandomElement(chineseAdverbsList));
        sb.append(ResourceUtils.getRandomElement(chineseVerbsList));
        sb.append(ResourceUtils.getRandomElement(chineseNounsList));
        r = RandomUtils.nextInt((int)1, (int)11);
        if (r % 2 == 0) {
            sb.append(ResourceUtils.getRandomElement(chineseNounsList));
        }
        if ((r = RandomUtils.nextInt((int)1, (int)101)) % 2 == 0) {
            r = RandomUtils.nextInt((int)1, (int)11);
            if (r % 2 == 0) {
                sb.append("\uff0c");
            } else {
                sb.append(ResourceUtils.getRandomElement(chineseParticlesList));
                sb.append("\uff1f");
            }
            r = RandomUtils.nextInt((int)1, (int)11);
            if (r % 2 == 0) {
                sb.append(ResourceUtils.getRandomElement(chineseConjunctionsList));
            }
            if ((r = RandomUtils.nextInt((int)1, (int)11)) % 3 == 0) {
                sb.append(ResourceUtils.getRandomElement(chinesePronounsList));
            }
            sb.append(ResourceUtils.getRandomElement(chineseNounsList));
            sb.append(ResourceUtils.getRandomElement(chineseVerbsList));
            sb.append(ResourceUtils.getRandomElement(chineseNounsList));
        }
        sb.append("\u3002");
        return sb.toString();
    }

    public String randomNonsense(String subject, String behavior) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)subject), (Object)"\u4e3b\u8bed\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)behavior), (Object)"\u884c\u4e3a\u4e0d\u80fd\u4e3a\u7a7a");
        String tpl = ResourceUtils.getRandomElement(nonsenseList);
        return tpl.replaceAll("A", subject).replaceAll("B", behavior);
    }

    public String randomNonsenseTitle(String subject, String behavior) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)subject), (Object)"\u4e3b\u8bed\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)behavior), (Object)"\u884c\u4e3a\u4e0d\u80fd\u4e3a\u7a7a");
        String tpl = ResourceUtils.getRandomElement(sensationalTitlesList);
        return ResourceUtils.getRandomElement(astonishingPrefixList) + "\uff01" + tpl.replaceAll("A", subject).replaceAll("B", behavior);
    }

    public Poem randomTangPoem() {
        return ResourceUtils.getRandomElement(tangPoemsList);
    }

    public String randomChineseIdiom() {
        return ResourceUtils.getRandomElement(chineseIdiomsList);
    }

    public String randomEnglishText(int words) {
        Preconditions.checkArgument((words > 1 ? 1 : 0) != 0, (Object)"\u8bcd\u8bed\u6570\u91cf\u5fc5\u987b\u5927\u4e8e1");
        return StringUtils.capitalize((String)Joiner.on((String)" ").join(ResourceUtils.getRandomElement(englishWordsList, words)));
    }

    public GreekAlphabet randomGreekAlphabet() {
        return ResourceUtils.getRandomElement(greekAlphabets);
    }
}

