/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

public class ResourceUtils {
    public static List<String> readLines(String fileName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fileName), (Object)"\u8d44\u6e90\u6587\u4ef6\u540d\u4e3a\u7a7a");
        try {
            return Resources.asCharSource((URL)Resources.getResource((String)fileName), (Charset)Charsets.UTF_8).readLines();
        }
        catch (IOException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8d44\u6e90\u6587\u4ef6\u5931\u8d25");
        }
    }

    public static <T> T getRandomElement(List<T> elementList) {
        if (CollectionUtils.isEmpty(elementList)) {
            return null;
        }
        int index = RandomUtils.nextInt((int)0, (int)elementList.size());
        return elementList.get(index);
    }

    public static String getRandomString(List<String> elementList, int n) {
        if (CollectionUtils.isEmpty(elementList) || n < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            int index = RandomUtils.nextInt((int)0, (int)elementList.size());
            sb.append(elementList.get(index));
        }
        return sb.toString();
    }
}

