/*
 * Decompiled with CFR 0.152.
 */
package com.apifan.common.random.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResourceUtils.class);

    public static List<String> readLines(String fileName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fileName), (Object)"\u8d44\u6e90\u6587\u4ef6\u540d\u4e3a\u7a7a");
        try {
            return Resources.asCharSource((URL)Resources.getResource((String)fileName), (Charset)Charsets.UTF_8).readLines();
        }
        catch (IOException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8d44\u6e90\u6587\u4ef6\u5931\u8d25");
        }
    }

    public static String readString(String fileName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fileName), (Object)"\u8d44\u6e90\u6587\u4ef6\u540d\u4e3a\u7a7a");
        try {
            return Resources.asCharSource((URL)Resources.getResource((String)fileName), (Charset)Charsets.UTF_8).read();
        }
        catch (IOException e) {
            throw new RuntimeException("\u8bfb\u53d6\u8d44\u6e90\u6587\u4ef6\u5931\u8d25");
        }
    }

    public static List<Map<String, Object>> readAsMapList(String fileName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)fileName), (Object)"\u8d44\u6e90\u6587\u4ef6\u540d\u4e3a\u7a7a");
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            CollectionType collectionType = objectMapper.getTypeFactory().constructCollectionType(List.class, Map.class);
            return (List)objectMapper.readValue(ResourceUtils.readString(fileName), (JavaType)collectionType);
        }
        catch (IOException e) {
            logger.error("\u89e3\u6790json\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static <T> T getRandomElement(List<T> elementList) {
        if (CollectionUtils.isEmpty(elementList)) {
            return null;
        }
        int index = RandomUtils.nextInt((int)0, (int)elementList.size());
        return elementList.get(index);
    }

    public static String getRandomString(List<String> elementList, int n) {
        if (CollectionUtils.isEmpty(elementList) || n < 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            int index = RandomUtils.nextInt((int)0, (int)elementList.size());
            sb.append(elementList.get(index));
        }
        return sb.toString();
    }

    public static String base64Decode(String text) {
        return new String(Base64.getDecoder().decode(text), StandardCharsets.UTF_8);
    }

    public static List<String> base64DecodeLines(List<String> lines) {
        if (CollectionUtils.isEmpty(lines)) {
            return Lists.newArrayList();
        }
        ArrayList decoded = Lists.newArrayList();
        lines.forEach(v -> {
            if (StringUtils.isBlank((CharSequence)v)) {
                return;
            }
            decoded.add(ResourceUtils.base64Decode(v));
        });
        return decoded;
    }
}

