/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin;

import com.apigee.edge.config.mavenplugin.GatewayAbstractMojo;
import com.apigee.edge.config.rest.RestUtil;
import com.apigee.edge.config.utils.ServerProfile;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.util.Key;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIProductMojo
extends GatewayAbstractMojo {
    static Logger logger = LoggerFactory.getLogger(APIProductMojo.class);
    public static final String ____ATTENTION_MARKER____ = "************************************************************************";
    OPTIONS buildOption = OPTIONS.none;
    private ServerProfile serverProfile;

    public void init() throws MojoFailureException {
        try {
            logger.info(____ATTENTION_MARKER____);
            logger.info("Apigee API Product");
            logger.info(____ATTENTION_MARKER____);
            String options = "";
            this.serverProfile = super.getProfile();
            options = super.getOptions();
            if (options != null) {
                this.buildOption = OPTIONS.valueOf(options);
            }
            logger.debug("Build option " + this.buildOption.name());
            logger.debug("Base dir " + super.getBaseDirectoryPath());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid apigee.option provided");
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected String getAPIProductName(String payload) throws MojoFailureException {
        Gson gson = new Gson();
        try {
            APIProduct product = (APIProduct)gson.fromJson(payload, APIProduct.class);
            return product.name;
        }
        catch (JsonParseException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void doUpdate(List<String> products) throws MojoFailureException {
        try {
            List existingAPIProducts = null;
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            logger.info("Retrieving existing API Products");
            existingAPIProducts = APIProductMojo.getAPIProduct(this.serverProfile);
            for (String product : products) {
                String productName = this.getAPIProductName(product);
                if (productName == null) {
                    throw new IllegalArgumentException("API Product does not have a name.\n" + product + "\n");
                }
                if (existingAPIProducts.contains(productName)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("API Product \"" + productName + "\" exists. Updating.");
                            APIProductMojo.updateAPIProduct(this.serverProfile, productName, product);
                            break;
                        }
                        case create: {
                            logger.info("API Product \"" + productName + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("API Product \"" + productName + "\" already exists. Deleting.");
                            APIProductMojo.deleteAPIProduct(this.serverProfile, productName);
                            break;
                        }
                        case sync: {
                            logger.info("API Product \"" + productName + "\" already exists. Deleting and recreating.");
                            APIProductMojo.deleteAPIProduct(this.serverProfile, productName);
                            logger.info("Creating API Product - " + productName);
                            APIProductMojo.createAPIProduct(this.serverProfile, product);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating API Product - " + productName);
                        APIProductMojo.createAPIProduct(this.serverProfile, product);
                        break;
                    }
                    case delete: {
                        logger.info("API Product \"" + productName + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Logger logger = LoggerFactory.getLogger(APIProductMojo.class);
        try {
            this.init();
            if (this.buildOption == OPTIONS.none) {
                logger.info("Skipping API Products (default action)");
                return;
            }
            if (this.serverProfile.getEnvironment() == null) {
                throw new MojoExecutionException("Apigee environment not found in profile");
            }
            List products = this.getOrgConfig(logger, "apiProducts");
            if (products == null || products.size() == 0) {
                logger.info("No API Products found.");
                return;
            }
            this.doUpdate(products);
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String createAPIProduct(ServerProfile profile, String product) throws IOException {
        HttpResponse response = RestUtil.createOrgConfig(profile, "apiproducts", product);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("API Product create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String updateAPIProduct(ServerProfile profile, String productName, String product) throws IOException {
        HttpResponse response = RestUtil.updateOrgConfig(profile, "apiproducts", productName, product);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("API Product update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteAPIProduct(ServerProfile profile, String productName) throws IOException {
        HttpResponse response = RestUtil.deleteOrgConfig(profile, "apiproducts", productName);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("API Product delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getAPIProduct(ServerProfile profile) throws IOException {
        HttpResponse response = RestUtil.getOrgConfig(profile, "apiproducts");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray products = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"products\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            products = (JSONArray)obj1.get((Object)"products");
        }
        catch (ParseException pe) {
            logger.error("Get API Product parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get API Product error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return products;
    }

    public static class APIProduct {
        @Key
        public String name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPTIONS {
        none,
        create,
        update,
        delete,
        sync;

    }
}

