/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin;

import com.apigee.edge.config.mavenplugin.GatewayAbstractMojo;
import com.apigee.edge.config.rest.RestUtil;
import com.apigee.edge.config.utils.ServerProfile;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.util.Key;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppMojo
extends GatewayAbstractMojo {
    static Logger logger = LoggerFactory.getLogger(AppMojo.class);
    public static final String ____ATTENTION_MARKER____ = "************************************************************************";
    OPTIONS buildOption = OPTIONS.none;
    private ServerProfile serverProfile;

    public void init() throws MojoFailureException {
        try {
            logger.info(____ATTENTION_MARKER____);
            logger.info("Apigee App");
            logger.info(____ATTENTION_MARKER____);
            String options = "";
            this.serverProfile = super.getProfile();
            options = super.getOptions();
            if (options != null) {
                this.buildOption = OPTIONS.valueOf(options);
            }
            logger.debug("Build option " + this.buildOption.name());
            logger.debug("Base dir " + super.getBaseDirectoryPath());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid apigee.option provided");
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected String getAppName(String payload) throws MojoFailureException {
        Gson gson = new Gson();
        try {
            App app = (App)gson.fromJson(payload, App.class);
            return app.name;
        }
        catch (JsonParseException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void doUpdate(Map<String, List<String>> devApps) throws MojoFailureException {
        try {
            List existingApps = null;
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            for (Map.Entry<String, List<String>> entry : devApps.entrySet()) {
                logger.info("Retrieving Apps of " + entry.getKey());
                String developerId = URLEncoder.encode(entry.getKey(), "UTF-8");
                existingApps = AppMojo.getApp(this.serverProfile, developerId);
                for (String app : entry.getValue()) {
                    String appName = this.getAppName(app);
                    if (appName == null) {
                        throw new IllegalArgumentException("App does not have a name.\n" + app + "\n");
                    }
                    if (existingApps.contains(appName)) {
                        switch (this.buildOption) {
                            case update: {
                                logger.info("App \"" + appName + "\" exists. Updating.");
                                AppMojo.updateApp(this.serverProfile, developerId, appName, app);
                                break;
                            }
                            case create: {
                                logger.info("App \"" + appName + "\" already exists. Skipping.");
                                break;
                            }
                            case delete: {
                                logger.info("App \"" + appName + "\" already exists. Deleting.");
                                AppMojo.deleteApp(this.serverProfile, developerId, appName);
                                break;
                            }
                            case sync: {
                                logger.info("App \"" + appName + "\" already exists. Deleting and recreating.");
                                AppMojo.deleteApp(this.serverProfile, developerId, appName);
                                logger.info("Creating App - " + appName);
                                AppMojo.createApp(this.serverProfile, developerId, app);
                            }
                        }
                        continue;
                    }
                    switch (this.buildOption) {
                        case update: 
                        case create: 
                        case sync: {
                            logger.info("Creating App - " + appName);
                            AppMojo.createApp(this.serverProfile, developerId, app);
                            break;
                        }
                        case delete: {
                            logger.info("App \"" + appName + "\" does not exist. Skipping.");
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Logger logger = LoggerFactory.getLogger(AppMojo.class);
        try {
            this.init();
            if (this.buildOption == OPTIONS.none) {
                logger.info("Skipping Apps (default action)");
                return;
            }
            if (this.serverProfile.getEnvironment() == null) {
                throw new MojoExecutionException("Apigee environment not found in profile");
            }
            Map apps = this.getOrgConfigWithId(logger, "developerApps");
            if (apps == null || apps.size() == 0) {
                logger.info("No developers apps found.");
                return;
            }
            logger.debug(apps.toString());
            this.doUpdate(apps);
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String createApp(ServerProfile profile, String developerId, String app) throws IOException {
        HttpResponse response = RestUtil.createOrgConfig(profile, "developers/" + developerId + "/apps", app);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("App create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String updateApp(ServerProfile profile, String developerId, String appName, String app) throws IOException {
        HttpResponse response = RestUtil.updateOrgConfig(profile, "developers/" + developerId + "/apps", appName, app);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("App update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteApp(ServerProfile profile, String developerId, String appName) throws IOException {
        HttpResponse response = RestUtil.deleteOrgConfig(profile, "developers/" + developerId + "/apps", appName);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("App delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getApp(ServerProfile profile, String developerId) throws IOException {
        HttpResponse response = RestUtil.getOrgConfig(profile, "developers/" + developerId + "/apps");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray apps = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"apps\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            apps = (JSONArray)obj1.get((Object)"apps");
        }
        catch (ParseException pe) {
            logger.error("Get App parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get Apps error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return apps;
    }

    public static class App {
        @Key
        public String name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPTIONS {
        none,
        create,
        update,
        delete,
        sync;

    }
}

