/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin;

import com.apigee.edge.config.mavenplugin.GatewayAbstractMojo;
import com.apigee.edge.config.rest.RestUtil;
import com.apigee.edge.config.utils.ServerProfile;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.util.Key;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMojo
extends GatewayAbstractMojo {
    static Logger logger = LoggerFactory.getLogger(CacheMojo.class);
    public static final String ____ATTENTION_MARKER____ = "************************************************************************";
    OPTIONS buildOption = OPTIONS.none;
    private ServerProfile serverProfile;

    public void init() throws MojoFailureException {
        try {
            logger.info(____ATTENTION_MARKER____);
            logger.info("Apigee Cache");
            logger.info(____ATTENTION_MARKER____);
            String options = "";
            this.serverProfile = super.getProfile();
            options = super.getOptions();
            if (options != null) {
                this.buildOption = OPTIONS.valueOf(options);
            }
            logger.debug("Build option " + this.buildOption.name());
            logger.debug("Base dir " + super.getBaseDirectoryPath());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid apigee.option provided");
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected String getCacheName(String payload) throws MojoFailureException {
        Gson gson = new Gson();
        try {
            Cache cache = (Cache)gson.fromJson(payload, Cache.class);
            return cache.name;
        }
        catch (JsonParseException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void doUpdate(List<String> caches) throws MojoFailureException {
        try {
            List existingCaches = null;
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            logger.info("Retrieving existing environment caches - " + this.serverProfile.getEnvironment());
            existingCaches = CacheMojo.getCache(this.serverProfile);
            for (String cache : caches) {
                String cacheName = this.getCacheName(cache);
                if (cacheName == null) {
                    throw new IllegalArgumentException("Cache does not have a name.\n" + cache + "\n");
                }
                if (existingCaches.contains(cacheName)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("Cache \"" + cacheName + "\" exists. Updating.");
                            CacheMojo.updateCache(this.serverProfile, cacheName, cache);
                            break;
                        }
                        case create: {
                            logger.info("Cache \"" + cacheName + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("Cache \"" + cacheName + "\" already exists. Deleting.");
                            CacheMojo.deleteCache(this.serverProfile, cacheName);
                            break;
                        }
                        case sync: {
                            logger.info("Cache \"" + cacheName + "\" already exists. Deleting and recreating.");
                            CacheMojo.deleteCache(this.serverProfile, cacheName);
                            logger.info("Creating Cache - " + cacheName);
                            CacheMojo.createCache(this.serverProfile, cache);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating Cache - " + cacheName);
                        CacheMojo.createCache(this.serverProfile, cache);
                        break;
                    }
                    case delete: {
                        logger.info("Cache \"" + cacheName + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Logger logger = LoggerFactory.getLogger(CacheMojo.class);
        try {
            this.init();
            if (this.buildOption == OPTIONS.none) {
                logger.info("Skipping Caches (default action)");
                return;
            }
            if (this.serverProfile.getEnvironment() == null) {
                throw new MojoExecutionException("Apigee environment not found in profile");
            }
            List caches = this.getEnvConfig(logger, "caches");
            if (caches == null || caches.size() == 0) {
                logger.info("No cache config found.");
                return;
            }
            this.doUpdate(caches);
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String createCache(ServerProfile profile, String cache) throws IOException {
        HttpResponse response = RestUtil.createEnvConfig(profile, "caches", cache);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Cache create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String updateCache(ServerProfile profile, String cacheName, String cache) throws IOException {
        HttpResponse response = RestUtil.updateEnvConfig(profile, "caches", cacheName, cache);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Cache update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteCache(ServerProfile profile, String cacheName) throws IOException {
        HttpResponse response = RestUtil.deleteEnvConfig(profile, "caches", cacheName);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Cache delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getCache(ServerProfile profile) throws IOException {
        HttpResponse response = RestUtil.getEnvConfig(profile, "caches");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray caches = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"caches\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            caches = (JSONArray)obj1.get((Object)"caches");
        }
        catch (ParseException pe) {
            logger.error("Get Cache parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get Cache error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return caches;
    }

    public static class Cache {
        @Key
        public String name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPTIONS {
        none,
        create,
        update,
        delete,
        sync;

    }
}

