/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin;

import com.apigee.edge.config.mavenplugin.GatewayAbstractMojo;
import com.apigee.edge.config.rest.RestUtil;
import com.apigee.edge.config.utils.ServerProfile;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.util.Key;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeveloperMojo
extends GatewayAbstractMojo {
    static Logger logger = LoggerFactory.getLogger(DeveloperMojo.class);
    public static final String ____ATTENTION_MARKER____ = "************************************************************************";
    OPTIONS buildOption = OPTIONS.none;
    private ServerProfile serverProfile;

    public void init() throws MojoFailureException {
        try {
            logger.info(____ATTENTION_MARKER____);
            logger.info("Apigee Developer");
            logger.info(____ATTENTION_MARKER____);
            String options = "";
            this.serverProfile = super.getProfile();
            options = super.getOptions();
            if (options != null) {
                this.buildOption = OPTIONS.valueOf(options);
            }
            logger.debug("Build option " + this.buildOption.name());
            logger.debug("Base dir " + super.getBaseDirectoryPath());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid apigee.option provided");
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected String getDeveloperName(String payload) throws MojoFailureException {
        Gson gson = new Gson();
        try {
            Developer developer = (Developer)gson.fromJson(payload, Developer.class);
            return developer.email;
        }
        catch (JsonParseException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void doUpdate(List<String> developers) throws MojoFailureException {
        try {
            List existingDevelopers = null;
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            logger.info("Retrieving existing Developers");
            existingDevelopers = DeveloperMojo.getDeveloper(this.serverProfile);
            for (String developer : developers) {
                String developerId = this.getDeveloperName(developer);
                if (developerId == null) {
                    throw new IllegalArgumentException("Developer does not have an id.\n" + developer + "\n");
                }
                if (existingDevelopers.contains(developerId)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("Developer \"" + developerId + "\" exists. Updating.");
                            DeveloperMojo.updateDeveloper(this.serverProfile, developerId, developer);
                            break;
                        }
                        case create: {
                            logger.info("Developer \"" + developerId + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("Developer \"" + developerId + "\" already exists. Deleting.");
                            DeveloperMojo.deleteDeveloper(this.serverProfile, developerId);
                            break;
                        }
                        case sync: {
                            logger.info("Developer \"" + developerId + "\" already exists. Deleting and recreating.");
                            DeveloperMojo.deleteDeveloper(this.serverProfile, developerId);
                            logger.info("Creating Developer - " + developerId);
                            DeveloperMojo.createDeveloper(this.serverProfile, developer);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating Developer - " + developerId);
                        DeveloperMojo.createDeveloper(this.serverProfile, developer);
                        break;
                    }
                    case delete: {
                        logger.info("Developer \"" + developerId + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Logger logger = LoggerFactory.getLogger(DeveloperMojo.class);
        try {
            this.init();
            if (this.buildOption == OPTIONS.none) {
                logger.info("Skipping Developers (default action)");
                return;
            }
            if (this.serverProfile.getEnvironment() == null) {
                throw new MojoExecutionException("Apigee environment not found in profile");
            }
            List developers = this.getOrgConfig(logger, "developers");
            if (developers == null || developers.size() == 0) {
                logger.info("No Developers found.");
                return;
            }
            this.doUpdate(developers);
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String createDeveloper(ServerProfile profile, String developer) throws IOException {
        HttpResponse response = RestUtil.createOrgConfig(profile, "developers", developer);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Developer create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String updateDeveloper(ServerProfile profile, String developerId, String developer) throws IOException {
        HttpResponse response = RestUtil.updateOrgConfig(profile, "developers", developerId, developer);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Developer update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteDeveloper(ServerProfile profile, String developerId) throws IOException {
        HttpResponse response = RestUtil.deleteOrgConfig(profile, "developers", developerId);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Developer delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getDeveloper(ServerProfile profile) throws IOException {
        HttpResponse response = RestUtil.getOrgConfig(profile, "developers");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray developers = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"developers\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            developers = (JSONArray)obj1.get((Object)"developers");
        }
        catch (ParseException pe) {
            logger.error("Get Developer parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get Developer error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return developers;
    }

    public static class Developer {
        @Key
        public String email;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPTIONS {
        none,
        create,
        update,
        delete,
        sync;

    }
}

