/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin;

import com.apigee.edge.config.mavenplugin.GatewayAbstractMojo;
import com.apigee.edge.config.rest.RestUtil;
import com.apigee.edge.config.utils.ServerProfile;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.util.Key;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowHookMojo
extends GatewayAbstractMojo {
    static Logger logger = LoggerFactory.getLogger(FlowHookMojo.class);
    public static final String ____ATTENTION_MARKER____ = "************************************************************************";
    OPTIONS buildOption = OPTIONS.none;
    private ServerProfile serverProfile;

    public void init() throws MojoFailureException {
        try {
            logger.info(____ATTENTION_MARKER____);
            logger.info("Apigee Flow Hook");
            logger.info(____ATTENTION_MARKER____);
            String options = "";
            this.serverProfile = super.getProfile();
            options = super.getOptions();
            if (options != null) {
                this.buildOption = OPTIONS.valueOf(options);
            }
            logger.debug("Build option " + this.buildOption.name());
            logger.debug("Base dir " + super.getBaseDirectoryPath());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid apigee.option provided");
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected String getFlowhookName(String payload) throws MojoFailureException {
        Gson gson = new Gson();
        try {
            FlowHook flowHook = (FlowHook)gson.fromJson(payload, FlowHook.class);
            return flowHook.name;
        }
        catch (JsonParseException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void doUpdate(List<String> flowhooks) throws MojoFailureException {
        try {
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            for (String flowhook : flowhooks) {
                String flowhookName = this.getFlowhookName(flowhook);
                if (flowhookName == null) {
                    throw new IllegalArgumentException("Flowhook does not have a name.\n" + flowhook + "\n");
                }
                switch (this.buildOption) {
                    case update: {
                        logger.info("Updating Flowhook " + flowhookName);
                        FlowHookMojo.createUpdateFlowhook(this.serverProfile, flowhookName, flowhook, "Update");
                        break;
                    }
                    case create: {
                        logger.info("Attaching Flowhook " + flowhookName);
                        FlowHookMojo.createUpdateFlowhook(this.serverProfile, flowhookName, flowhook, "Create");
                        break;
                    }
                    case delete: {
                        logger.info("Detaching Flowhook " + flowhookName);
                        FlowHookMojo.deleteFlowhook(this.serverProfile, flowhookName, flowhook);
                        break;
                    }
                    case sync: {
                        logger.info("Detaching Flowhook " + flowhookName);
                        FlowHookMojo.deleteFlowhook(this.serverProfile, flowhookName, flowhook);
                        logger.info("Attaching Flowhook " + flowhookName);
                        FlowHookMojo.createUpdateFlowhook(this.serverProfile, flowhookName, flowhook, "Create");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Logger logger = LoggerFactory.getLogger(FlowHookMojo.class);
        try {
            this.init();
            if (this.buildOption == OPTIONS.none) {
                logger.info("Skipping Flow Hooks (default action)");
                return;
            }
            if (this.serverProfile.getEnvironment() == null) {
                throw new MojoExecutionException("Apigee environment not found in profile");
            }
            List flowhooks = this.getEnvConfig(logger, "flowhooks");
            if (flowhooks == null || flowhooks.size() == 0) {
                logger.info("No flowhooks config found.");
                return;
            }
            this.doUpdate(flowhooks);
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String createUpdateFlowhook(ServerProfile profile, String flowhookName, String flowhook, String operation) throws IOException {
        HttpResponse response = RestUtil.updateEnvConfig(profile, "flowhooks", flowhookName, flowhook);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info(operation + " Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("flowhook " + operation + " error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteFlowhook(ServerProfile profile, String flowhookName, String flowhook) throws IOException {
        HttpResponse response = RestUtil.deleteEnvConfig(profile, "flowhooks", flowhookName, flowhook);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Flowhook delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getFlowhook(ServerProfile profile) throws IOException {
        HttpResponse response = RestUtil.getEnvConfig(profile, "flowhooks");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray flowhooks = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"flowhooks\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            flowhooks = (JSONArray)obj1.get((Object)"flowhooks");
        }
        catch (ParseException pe) {
            logger.error("Get flowhook parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get flowhook error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return flowhooks;
    }

    public static class FlowHook {
        @Key
        public String name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPTIONS {
        none,
        create,
        update,
        delete,
        sync;

    }
}

