/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin;

import com.apigee.edge.config.utils.ConfigReader;
import com.apigee.edge.config.utils.ConsolidatedConfigReader;
import com.apigee.edge.config.utils.ServerProfile;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GatewayAbstractMojo
extends AbstractMojo {
    private File buildDirectory;
    private File baseDirectory;
    private String projectName;
    private String projectVersion;
    private String artifactId;
    private String id;
    private String hostURL;
    private String deploymentEnv;
    private String apiVersion;
    private String orgName;
    private String userName;
    private String password;
    private String buildOption;
    private String options;
    private String configDir;
    private String exportDir;
    private String tokenURL;
    private String mfaToken;
    private String authType;
    private String bearer;
    private String refresh;
    private String clientid;
    private String clientsecret;
    private boolean skip = false;
    public ServerProfile buildProfile;

    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public ServerProfile getProfile() {
        this.buildProfile = new ServerProfile();
        this.buildProfile.setOrg(this.orgName);
        this.buildProfile.setApplication(this.projectName);
        this.buildProfile.setApi_version(this.apiVersion);
        this.buildProfile.setHostUrl(this.hostURL);
        this.buildProfile.setEnvironment(this.deploymentEnv);
        this.buildProfile.setCredential_user(this.userName);
        this.buildProfile.setCredential_pwd(this.password);
        this.buildProfile.setProfileId(this.id);
        this.buildProfile.setOptions(this.options);
        this.buildProfile.setTokenUrl(this.tokenURL);
        this.buildProfile.setMFAToken(this.mfaToken);
        this.buildProfile.setAuthType(this.authType);
        this.buildProfile.setBearerToken(this.bearer);
        this.buildProfile.setRefreshToken(this.refresh);
        this.buildProfile.setClientId(this.clientid);
        this.buildProfile.setClientSecret(this.clientsecret);
        return this.buildProfile;
    }

    public void setProfile(ServerProfile profile) {
        this.buildProfile = profile;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public String getBuildDirectory() {
        return this.buildDirectory.getAbsolutePath();
    }

    public String getBaseDirectoryPath() {
        return this.baseDirectory.getAbsolutePath();
    }

    public String getBuildOption() {
        return this.buildOption;
    }

    public void setBuildOption(String buildOption) {
        this.buildOption = buildOption;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private File findConsolidatedConfigFile() throws MojoExecutionException {
        File configFile = new File(this.getBaseDirectoryPath() + File.separator + "edge.json");
        if (configFile.exists()) {
            return configFile;
        }
        return null;
    }

    private File findConfigFile(String scope, String config) throws MojoExecutionException {
        File configFile = new File(this.configDir + File.separator + scope + File.separator + config + ".json");
        if (configFile.exists()) {
            return configFile;
        }
        return null;
    }

    protected List getAPIConfig(Logger logger, String config, String api) throws MojoExecutionException {
        String scope = "api" + File.separator + api;
        if (this.configDir != null && this.configDir.length() > 0) {
            File configFile = this.findConfigFile(scope, config);
            if (configFile == null) {
                logger.info("Config file " + scope + File.separator + config + ".json not found.");
                return null;
            }
            logger.info("Retrieving config from " + scope + File.separator + config + ".json");
            try {
                return ConfigReader.getAPIConfig(configFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        File configFile = this.findConsolidatedConfigFile();
        if (configFile == null) {
            logger.info("No edge.json found.");
            throw new MojoExecutionException("config file edge.json not found");
        }
        logger.debug("Retrieving config from edge.json");
        try {
            return ConsolidatedConfigReader.getAPIConfig(configFile, api, config);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected Set<String> getAPIList(Logger logger) throws MojoExecutionException {
        String scope = this.configDir + File.separator + "api";
        if (this.configDir != null && this.configDir.length() > 0) {
            logger.info("Retrieving API list from " + scope);
            try {
                return ConfigReader.getAPIList(scope);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        File configFile = this.findConsolidatedConfigFile();
        if (configFile == null) {
            logger.info("No edge.json found.");
            throw new MojoExecutionException("config file edge.json not found");
        }
        logger.debug("Retrieving config from edge.json");
        try {
            return ConsolidatedConfigReader.getAPIList(configFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected List getEnvConfig(Logger logger, String config) throws MojoExecutionException {
        String scope = "env" + File.separator + this.buildProfile.getEnvironment();
        if (this.configDir != null && this.configDir.length() > 0) {
            File configFile = this.findConfigFile(scope, config);
            if (configFile == null) {
                logger.info("Config file " + scope + File.separator + config + ".json not found.");
                return null;
            }
            logger.info("Retrieving config from " + scope + File.separator + config + ".json");
            try {
                return ConfigReader.getEnvConfig(this.buildProfile.getEnvironment(), configFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        File configFile = this.findConsolidatedConfigFile();
        if (configFile == null) {
            logger.info("No edge.json found.");
            throw new MojoExecutionException("config file edge.json not found");
        }
        logger.debug("Retrieving config from edge.json");
        try {
            List envConfigs = ConsolidatedConfigReader.getEnvConfig(this.buildProfile.getEnvironment(), configFile, "envConfig", config);
            return envConfigs;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected List getOrgConfig(Logger logger, String config) throws MojoExecutionException {
        String scope = "org";
        if (this.configDir != null && this.configDir.length() > 0) {
            File configFile = this.findConfigFile(scope, config);
            if (configFile == null) {
                logger.info("Config file " + scope + File.separator + config + ".json not found.");
                return null;
            }
            logger.info("Retrieving config from " + scope + File.separator + config + ".json");
            try {
                return ConfigReader.getOrgConfig(configFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        File configFile = this.findConsolidatedConfigFile();
        if (configFile == null) {
            logger.info("No edge.json found.");
            throw new MojoExecutionException("config file edge.json not found");
        }
        logger.debug("Retrieving config from edge.json");
        try {
            return ConsolidatedConfigReader.getOrgConfig(configFile, "orgConfig", config);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    protected Map getOrgConfigWithId(Logger logger, String config) throws MojoExecutionException {
        String scope = "org";
        if (this.configDir != null && this.configDir.length() > 0) {
            File configFile = this.findConfigFile(scope, config);
            if (configFile == null) {
                logger.info("Config file " + scope + File.separator + config + ".json not found.");
                return null;
            }
            logger.info("Retrieving config from " + scope + File.separator + config + ".json");
            try {
                return ConfigReader.getOrgConfigWithId(configFile);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage());
            }
        }
        File configFile = this.findConsolidatedConfigFile();
        if (configFile == null) {
            logger.info("No edge.json found.");
            throw new MojoExecutionException("config file edge.json not found");
        }
        logger.debug("Retrieving config from edge.json");
        try {
            return ConsolidatedConfigReader.getOrgConfigWithId(configFile, "orgConfig", config);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

