/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin;

import com.apigee.edge.config.mavenplugin.GatewayAbstractMojo;
import com.apigee.edge.config.mavenplugin.kvm.Kvm;
import com.apigee.edge.config.mavenplugin.kvm.KvmApi;
import com.apigee.edge.config.mavenplugin.kvm.KvmEnv;
import com.apigee.edge.config.mavenplugin.kvm.KvmOrg;
import com.apigee.edge.config.mavenplugin.kvm.KvmValueObject;
import com.apigee.edge.config.rest.RestUtil;
import com.apigee.edge.config.utils.ServerProfile;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.util.Key;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KVMMojo
extends GatewayAbstractMojo {
    static Logger logger = LoggerFactory.getLogger(KVMMojo.class);
    public static final String ____ATTENTION_MARKER____ = "************************************************************************";
    OPTIONS buildOption = OPTIONS.none;
    private ServerProfile serverProfile;
    private Kvm kvmOrg;
    private Kvm kvmApi;
    private Kvm kvmEnv;

    public void init() throws MojoFailureException {
        try {
            logger.info(____ATTENTION_MARKER____);
            logger.info("Apigee KVM");
            logger.info(____ATTENTION_MARKER____);
            String options = "";
            this.serverProfile = super.getProfile();
            this.kvmOrg = new KvmOrg();
            this.kvmApi = new KvmApi();
            this.kvmEnv = new KvmEnv();
            options = super.getOptions();
            if (options != null) {
                this.buildOption = OPTIONS.valueOf(options);
            }
            logger.debug("Build option " + this.buildOption.name());
            logger.debug("Base dir " + super.getBaseDirectoryPath());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid apigee.option provided");
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected String getKVMName(String payload) throws MojoFailureException {
        Gson gson = new Gson();
        try {
            KVM kvm = (KVM)gson.fromJson(payload, KVM.class);
            return kvm.name;
        }
        catch (JsonParseException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void doOrgUpdate(List<String> kvms, String scope) throws MojoFailureException {
        try {
            List existingKVM = KVMMojo.getOrgKVM(this.serverProfile);
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            for (String kvm : kvms) {
                String kvmName = this.getKVMName(kvm);
                if (kvmName == null) {
                    throw new IllegalArgumentException("KVM does not have a name.\n" + kvm + "\n");
                }
                if (existingKVM.contains(kvmName)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("Org KVM \"" + kvmName + "\" exists. Updating.");
                            this.kvmOrg.update(new KvmValueObject(this.serverProfile, kvmName, kvm));
                            break;
                        }
                        case create: {
                            logger.info("Org KVM \"" + kvmName + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("Org KVM \"" + kvmName + "\" already exists. Deleting.");
                            KVMMojo.deleteOrgKVM(this.serverProfile, kvmName);
                            break;
                        }
                        case sync: {
                            logger.info("Org KVM \"" + kvmName + "\" already exists. Deleting and recreating.");
                            KVMMojo.deleteOrgKVM(this.serverProfile, kvmName);
                            logger.info("Creating Org KVM - " + kvmName);
                            KVMMojo.createOrgKVM(this.serverProfile, kvm);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating Org KVM - " + kvmName);
                        KVMMojo.createOrgKVM(this.serverProfile, kvm);
                        break;
                    }
                    case delete: {
                        logger.info("Org KVM \"" + kvmName + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected void doEnvUpdate(List<String> kvms, String scope) throws MojoFailureException {
        try {
            List existingKVM = KVMMojo.getEnvKVM(this.serverProfile);
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            for (String kvm : kvms) {
                String kvmName = this.getKVMName(kvm);
                if (kvmName == null) {
                    throw new IllegalArgumentException("KVM does not have a name.\n" + kvm + "\n");
                }
                if (existingKVM.contains(kvmName)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("Env KVM \"" + kvmName + "\" exists. Updating.");
                            this.kvmEnv.update(new KvmValueObject(this.serverProfile, kvmName, kvm));
                            break;
                        }
                        case create: {
                            logger.info("Env KVM \"" + kvmName + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("Env KVM \"" + kvmName + "\" already exists. Deleting.");
                            KVMMojo.deleteEnvKVM(this.serverProfile, kvmName);
                            break;
                        }
                        case sync: {
                            logger.info("Env KVM \"" + kvmName + "\" already exists. Deleting and recreating.");
                            KVMMojo.deleteEnvKVM(this.serverProfile, kvmName);
                            logger.info("Creating Env KVM - " + kvmName);
                            KVMMojo.createEnvKVM(this.serverProfile, kvm);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating Env KVM - " + kvmName);
                        KVMMojo.createEnvKVM(this.serverProfile, kvm);
                        break;
                    }
                    case delete: {
                        logger.info("Env KVM \"" + kvmName + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected void doAPIUpdate(String api, List<String> kvms) throws MojoFailureException {
        try {
            List existingKVM = KVMMojo.getAPIKVM(this.serverProfile, api);
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            for (String kvm : kvms) {
                String kvmName = this.getKVMName(kvm);
                if (kvmName == null) {
                    throw new IllegalArgumentException("KVM does not have a name.\n" + kvm + "\n");
                }
                if (existingKVM.contains(kvmName)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("API KVM \"" + kvmName + "\" exists. Updating.");
                            this.kvmApi.update(new KvmValueObject(this.serverProfile, api, kvmName, kvm));
                            break;
                        }
                        case create: {
                            logger.info("API KVM \"" + kvmName + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("API KVM \"" + kvmName + "\" already exists. Deleting.");
                            KVMMojo.deleteAPIKVM(this.serverProfile, api, kvmName);
                            break;
                        }
                        case sync: {
                            logger.info("API KVM \"" + kvmName + "\" already exists. Deleting and recreating.");
                            KVMMojo.deleteAPIKVM(this.serverProfile, api, kvmName);
                            logger.info("Creating API KVM - " + kvmName);
                            KVMMojo.createAPIKVM(this.serverProfile, api, kvm);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating API KVM - " + kvmName);
                        KVMMojo.createAPIKVM(this.serverProfile, api, kvm);
                        break;
                    }
                    case delete: {
                        logger.info("API KVM \"" + kvmName + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Logger logger = LoggerFactory.getLogger(KVMMojo.class);
        try {
            this.init();
            if (this.buildOption == OPTIONS.none) {
                logger.info("Skipping KVM (default action)");
                return;
            }
            if (this.serverProfile.getEnvironment() == null) {
                throw new MojoExecutionException("Apigee environment not found in profile");
            }
            String scope = "orgConfig";
            List kvms = this.getOrgConfig(logger, "kvms");
            if (kvms == null || kvms.size() == 0) {
                logger.info("No org scoped KVM config found.");
            } else {
                this.doOrgUpdate(kvms, scope);
            }
            kvms = this.getEnvConfig(logger, "kvms");
            if (kvms == null || kvms.size() == 0) {
                logger.info("No env scoped KVM config found.");
            } else {
                this.doEnvUpdate(kvms, scope);
            }
            Set<String> apis = this.getAPIList(logger);
            if (apis == null || apis.size() == 0) {
                logger.info("No API scoped KVM config found.");
                return;
            }
            for (String api : apis) {
                kvms = this.getAPIConfig(logger, "kvms", api);
                if (kvms == null || kvms.size() == 0) {
                    logger.info("No API scoped KVM config found for " + api);
                    continue;
                }
                this.doAPIUpdate(api, kvms);
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String createOrgKVM(ServerProfile profile, String kvm) throws IOException {
        HttpResponse response = RestUtil.createOrgConfig(profile, "keyvaluemaps", kvm);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("KVM create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteOrgKVM(ServerProfile profile, String kvmEntry) throws IOException {
        HttpResponse response = RestUtil.deleteOrgConfig(profile, "keyvaluemaps", kvmEntry);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("KVM delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getOrgKVM(ServerProfile profile) throws IOException {
        HttpResponse response = RestUtil.getOrgConfig(profile, "keyvaluemaps");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray kvms = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"kvms\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            kvms = (JSONArray)obj1.get((Object)"kvms");
        }
        catch (ParseException pe) {
            logger.error("Get KVM parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get KVM error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return kvms;
    }

    public static String createEnvKVM(ServerProfile profile, String kvm) throws IOException {
        HttpResponse response = RestUtil.createEnvConfig(profile, "keyvaluemaps", kvm);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("KVM create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteEnvKVM(ServerProfile profile, String kvmEntry) throws IOException {
        HttpResponse response = RestUtil.deleteEnvConfig(profile, "keyvaluemaps", kvmEntry);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("KVM delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getEnvKVM(ServerProfile profile) throws IOException {
        HttpResponse response = RestUtil.getEnvConfig(profile, "keyvaluemaps");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray kvms = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"kvms\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            kvms = (JSONArray)obj1.get((Object)"kvms");
        }
        catch (ParseException pe) {
            logger.error("Get KVM parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get KVM error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return kvms;
    }

    public static String createAPIKVM(ServerProfile profile, String api, String kvm) throws IOException {
        HttpResponse response = RestUtil.createAPIConfig(profile, api, "keyvaluemaps", kvm);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("KVM create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteAPIKVM(ServerProfile profile, String api, String kvmEntry) throws IOException {
        HttpResponse response = RestUtil.deleteAPIConfig(profile, api, "keyvaluemaps", kvmEntry);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("KVM delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getAPIKVM(ServerProfile profile, String api) throws IOException {
        HttpResponse response = RestUtil.getAPIConfig(profile, api, "keyvaluemaps");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray kvms = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"kvms\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            kvms = (JSONArray)obj1.get((Object)"kvms");
        }
        catch (ParseException pe) {
            logger.error("Get KVM parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get KVM error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return kvms;
    }

    public static class KVM {
        @Key
        public String name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPTIONS {
        none,
        create,
        update,
        delete,
        sync;

    }
}

