/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin;

import com.apigee.edge.config.mavenplugin.GatewayAbstractMojo;
import com.apigee.edge.config.rest.RestUtil;
import com.apigee.edge.config.utils.ServerProfile;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.util.Key;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaskConfigMojo
extends GatewayAbstractMojo {
    static Logger logger = LoggerFactory.getLogger(MaskConfigMojo.class);
    public static final String ____ATTENTION_MARKER____ = "************************************************************************";
    OPTIONS buildOption = OPTIONS.none;
    private ServerProfile serverProfile;

    public void init() throws MojoFailureException {
        try {
            logger.info(____ATTENTION_MARKER____);
            logger.info("Apigee Mask Config");
            logger.info(____ATTENTION_MARKER____);
            String options = "";
            this.serverProfile = super.getProfile();
            options = super.getOptions();
            if (options != null) {
                this.buildOption = OPTIONS.valueOf(options);
            }
            logger.debug("Build option " + this.buildOption.name());
            logger.debug("Base dir " + super.getBaseDirectoryPath());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid apigee.option provided");
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected String getMaskConfigName(String payload) throws MojoFailureException {
        Gson gson = new Gson();
        try {
            MaskConfig maskConfig = (MaskConfig)gson.fromJson(payload, MaskConfig.class);
            return maskConfig.name;
        }
        catch (JsonParseException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void doOrgUpdate(List<String> masks) throws MojoFailureException {
        try {
            List existingMasks = MaskConfigMojo.getOrgMaskConfig(this.serverProfile);
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            for (String mask : masks) {
                String maskName = this.getMaskConfigName(mask);
                if (maskName == null) {
                    throw new IllegalArgumentException("Mask Config does not have a name.\n" + mask + "\n");
                }
                if (existingMasks.contains(maskName)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("Org Mask Config \"" + maskName + "\" exists. Updating.");
                            MaskConfigMojo.updateOrgMaskConfig(this.serverProfile, maskName, mask);
                            break;
                        }
                        case create: {
                            logger.info("Org Mask Config \"" + maskName + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("Org Mask Config \"" + maskName + "\" already exists. Deleting.");
                            MaskConfigMojo.deleteOrgMaskConfig(this.serverProfile, maskName);
                            break;
                        }
                        case sync: {
                            logger.info("Org Mask Config \"" + maskName + "\" already exists. Deleting and recreating.");
                            MaskConfigMojo.deleteOrgMaskConfig(this.serverProfile, maskName);
                            logger.info("Creating Org Mask Config - " + maskName);
                            MaskConfigMojo.createOrgMaskConfig(this.serverProfile, mask);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating Org Mask Config - " + maskName);
                        MaskConfigMojo.createOrgMaskConfig(this.serverProfile, mask);
                        break;
                    }
                    case delete: {
                        logger.info("Org Mask Config \"" + maskName + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected void doAPIUpdate(String api, List<String> masks) throws MojoFailureException {
        try {
            List existingMasks = MaskConfigMojo.getAPIMaskConfig(this.serverProfile, api);
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            for (String mask : masks) {
                String maskName = this.getMaskConfigName(mask);
                if (maskName == null) {
                    throw new IllegalArgumentException("Mask Config does not have a name.\n" + mask + "\n");
                }
                if (existingMasks.contains(maskName)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("API Mask Config \"" + maskName + "\" exists. Updating.");
                            MaskConfigMojo.updateAPIMaskConfig(this.serverProfile, api, maskName, mask);
                            break;
                        }
                        case create: {
                            logger.info("API Mask Config \"" + maskName + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("API Mask Config \"" + maskName + "\" already exists. Deleting.");
                            MaskConfigMojo.deleteAPIMaskConfig(this.serverProfile, api, maskName);
                            break;
                        }
                        case sync: {
                            logger.info("API Mask Config \"" + maskName + "\" already exists. Deleting and recreating.");
                            MaskConfigMojo.deleteAPIMaskConfig(this.serverProfile, api, maskName);
                            logger.info("Creating API Mask Config - " + maskName);
                            MaskConfigMojo.createAPIMaskConfig(this.serverProfile, api, mask);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating API Mask Config - " + maskName);
                        MaskConfigMojo.createAPIMaskConfig(this.serverProfile, api, mask);
                        break;
                    }
                    case delete: {
                        logger.info("API Mask Config \"" + maskName + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Logger logger = LoggerFactory.getLogger(MaskConfigMojo.class);
        try {
            this.init();
            if (this.buildOption == OPTIONS.none) {
                logger.info("Skipping Mask Config (default action)");
                return;
            }
            if (this.serverProfile.getEnvironment() == null) {
                throw new MojoExecutionException("Apigee environment not found in profile");
            }
            List maskConfigs = this.getOrgConfig(logger, "maskconfigs");
            if (maskConfigs == null || maskConfigs.size() == 0) {
                logger.info("No org scoped Mask config found.");
            } else {
                this.doOrgUpdate(maskConfigs);
            }
            Set<String> apis = this.getAPIList(logger);
            if (apis == null || apis.size() == 0) {
                logger.info("No API scoped Mask config found in edge.json.");
                return;
            }
            for (String api : apis) {
                maskConfigs = this.getAPIConfig(logger, "maskconfigs", api);
                if (maskConfigs == null || maskConfigs.size() == 0) {
                    logger.info("No API scoped Mask config found in edge.json.");
                    continue;
                }
                this.doAPIUpdate(api, maskConfigs);
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String createOrgMaskConfig(ServerProfile profile, String mask) throws IOException {
        HttpResponse response = RestUtil.createOrgConfig(profile, "maskconfigs", mask);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Mask Config create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String updateOrgMaskConfig(ServerProfile profile, String maskEntry, String mask) throws IOException {
        HttpResponse response = RestUtil.updateOrgConfig(profile, "maskconfigs", maskEntry, mask);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Mask Config update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteOrgMaskConfig(ServerProfile profile, String maskEntry) throws IOException {
        HttpResponse response = RestUtil.deleteOrgConfig(profile, "maskconfigs", maskEntry);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Mask Config delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getOrgMaskConfig(ServerProfile profile) throws IOException {
        HttpResponse response = RestUtil.getOrgConfig(profile, "maskconfigs");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray masks = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"masks\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            masks = (JSONArray)obj1.get((Object)"masks");
        }
        catch (ParseException pe) {
            logger.error("Get Mask Config parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get Mask Config error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return masks;
    }

    public static String createAPIMaskConfig(ServerProfile profile, String api, String mask) throws IOException {
        HttpResponse response = RestUtil.createAPIConfig(profile, api, "maskconfigs", mask);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Mask Config create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String updateAPIMaskConfig(ServerProfile profile, String api, String maskEntry, String mask) throws IOException {
        HttpResponse response = RestUtil.updateAPIConfig(profile, api, "maskconfigs", maskEntry, mask);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Mask Config update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteAPIMaskConfig(ServerProfile profile, String api, String maskEntry) throws IOException {
        HttpResponse response = RestUtil.deleteAPIConfig(profile, api, "maskconfigs", maskEntry);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Mask Config delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getAPIMaskConfig(ServerProfile profile, String api) throws IOException {
        HttpResponse response = RestUtil.getAPIConfig(profile, api, "maskconfigs");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray masks = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"masks\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            masks = (JSONArray)obj1.get((Object)"masks");
        }
        catch (ParseException pe) {
            logger.error("Get Mask Config parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get Mask Config error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return masks;
    }

    public static class MaskConfig {
        @Key
        public String name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPTIONS {
        none,
        create,
        update,
        delete,
        sync;

    }
}

