/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin;

import com.apigee.edge.config.mavenplugin.GatewayAbstractMojo;
import com.apigee.edge.config.rest.RestUtil;
import com.apigee.edge.config.utils.ServerProfile;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.util.Key;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFileMojo
extends GatewayAbstractMojo {
    static Logger logger = LoggerFactory.getLogger(ResourceFileMojo.class);
    public static final String ____ATTENTION_MARKER____ = "************************************************************************";
    OPTIONS buildOption = OPTIONS.none;
    private ServerProfile serverProfile;

    public void init() throws MojoFailureException {
        try {
            logger.info(____ATTENTION_MARKER____);
            logger.info("Apigee Resource File");
            logger.info(____ATTENTION_MARKER____);
            String options = "";
            this.serverProfile = super.getProfile();
            options = super.getOptions();
            if (options != null) {
                this.buildOption = OPTIONS.valueOf(options);
            }
            logger.debug("Build option " + this.buildOption.name());
            logger.debug("Base dir " + super.getBaseDirectoryPath());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid apigee.option provided");
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected ResourceFile getResourceFile(String payload) throws MojoFailureException {
        Gson gson = new Gson();
        try {
            ResourceFile resourceFile = (ResourceFile)gson.fromJson(payload, ResourceFile.class);
            return resourceFile;
        }
        catch (JsonParseException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void doOrgUpdate(List<String> resourcefiles, String scope) throws MojoFailureException {
        try {
            List existingResourcefile = ResourceFileMojo.getExistingResourceFile(this.serverProfile, "org", null);
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            for (String resourcefile : resourcefiles) {
                String resourcefileName = this.getResourceFile((String)resourcefile).name;
                String resourcefileType = this.getResourceFile((String)resourcefile).type;
                String resourcefilePath = this.getResourceFile((String)resourcefile).file;
                if (resourcefileName == null) {
                    throw new IllegalArgumentException("Resource File does not have a name.\n" + resourcefile + "\n");
                }
                if (existingResourcefile.contains(resourcefileName + "_" + resourcefileType)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("Org Resource File \"" + resourcefileName + "\" exists. Updating.");
                            ResourceFileMojo.updateOrgResourceFile(this.serverProfile, resourcefileType, resourcefileName, resourcefilePath);
                            break;
                        }
                        case create: {
                            logger.info("Org Resource File \"" + resourcefileName + " of type " + resourcefileType + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("Org Resource File \"" + resourcefileName + " of type " + resourcefileType + "\" already exists. Deleting.");
                            ResourceFileMojo.deleteOrgResourceFile(this.serverProfile, resourcefileType, resourcefileName);
                            break;
                        }
                        case sync: {
                            logger.info("Org Resource File \"" + resourcefileName + " of type " + resourcefileType + "\" already exists. Deleting and recreating.");
                            ResourceFileMojo.deleteOrgResourceFile(this.serverProfile, resourcefileType, resourcefileName);
                            logger.info("Creating Org Resource File - " + resourcefileName);
                            ResourceFileMojo.createOrgResourceFile(this.serverProfile, resourcefileType, resourcefileName, resourcefilePath);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating Org Resource File - " + resourcefileName + " of type " + resourcefileType);
                        ResourceFileMojo.createOrgResourceFile(this.serverProfile, resourcefileType, resourcefileName, resourcefilePath);
                        break;
                    }
                    case delete: {
                        logger.info("Org Resource File \"" + resourcefileName + " of type " + resourcefileType + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected void doEnvUpdate(List<String> resourcefiles, String scope) throws MojoFailureException {
        try {
            List existingResourcefile = ResourceFileMojo.getExistingResourceFile(this.serverProfile, "env", null);
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            for (String resourcefile : resourcefiles) {
                String resourcefileName = this.getResourceFile((String)resourcefile).name;
                String resourcefileType = this.getResourceFile((String)resourcefile).type;
                String resourcefilePath = this.getResourceFile((String)resourcefile).file;
                if (resourcefileName == null) {
                    throw new IllegalArgumentException("resourcefile does not have a name.\n" + resourcefile + "\n");
                }
                if (existingResourcefile.contains(resourcefileName + "_" + resourcefileType)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("Env Resource File \"" + resourcefileName + "\" exists. Updating.");
                            ResourceFileMojo.updateEnvResourceFile(this.serverProfile, resourcefileType, resourcefileName, resourcefilePath);
                            break;
                        }
                        case create: {
                            logger.info("Env Resource File \"" + resourcefileName + " of type " + resourcefileType + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("Env Resource File \"" + resourcefileName + " of type " + resourcefileType + "\" already exists. Deleting.");
                            ResourceFileMojo.deleteEnvResourceFile(this.serverProfile, resourcefileType, resourcefileName);
                            break;
                        }
                        case sync: {
                            logger.info("Env Resource File \"" + resourcefileName + " of type " + resourcefileType + "\" already exists. Deleting and recreating.");
                            ResourceFileMojo.deleteEnvResourceFile(this.serverProfile, resourcefileType, resourcefileName);
                            logger.info("Creating Env Resource File - " + resourcefileName);
                            ResourceFileMojo.createEnvResourceFile(this.serverProfile, resourcefileType, resourcefileName, resourcefilePath);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating Env Resource File - " + resourcefileName + " of type " + resourcefileType);
                        ResourceFileMojo.createEnvResourceFile(this.serverProfile, resourcefileType, resourcefileName, resourcefilePath);
                        break;
                    }
                    case delete: {
                        logger.info("Env Resource File \"" + resourcefileName + " of type " + resourcefileType + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected void doAPIUpdate(String api, List<String> resourcefiles) throws MojoFailureException {
        try {
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            for (String resourcefile : resourcefiles) {
                String resourcefileName = this.getResourceFile((String)resourcefile).name;
                String resourcefileType = this.getResourceFile((String)resourcefile).type;
                String resourcefilePath = this.getResourceFile((String)resourcefile).file;
                String revision = this.getResourceFile((String)resourcefile).revision;
                if (resourcefileName == null) {
                    throw new IllegalArgumentException("resourcefile does not have a name.\n" + resourcefile + "\n");
                }
                List existingResourcefile = ResourceFileMojo.getExistingResourceFile(this.serverProfile, "api", api + "/revisions/" + revision);
                if (existingResourcefile.contains(resourcefileName + "_" + resourcefileType)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("API Resource File \"" + resourcefileName + "\" exists. Updating.");
                            ResourceFileMojo.updateAPIResourceFile(this.serverProfile, api, revision, resourcefileType, resourcefileName, resourcefilePath);
                            break;
                        }
                        case create: {
                            logger.info("API Resource File \"" + resourcefileName + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("API Resource File \"" + resourcefileName + "\" already exists. Deleting.");
                            ResourceFileMojo.deleteAPIResourceFile(this.serverProfile, api, revision, resourcefileType, resourcefileName);
                            break;
                        }
                        case sync: {
                            logger.info("API Resource File \"" + resourcefileName + "\" already exists. Deleting and recreating.");
                            ResourceFileMojo.deleteAPIResourceFile(this.serverProfile, api, revision, resourcefileType, resourcefileName);
                            logger.info("Creating API Resource File - " + resourcefileName);
                            ResourceFileMojo.createAPIResourceFile(this.serverProfile, api, revision, resourcefileType, resourcefileName, resourcefilePath);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating API Resource File - " + resourcefileName);
                        ResourceFileMojo.createAPIResourceFile(this.serverProfile, api, revision, resourcefileType, resourcefileName, resourcefilePath);
                        break;
                    }
                    case delete: {
                        logger.info("API Resource File \"" + resourcefileName + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Logger logger = LoggerFactory.getLogger(ResourceFileMojo.class);
        try {
            this.init();
            if (this.buildOption == OPTIONS.none) {
                logger.info("Skipping Resource File (default action)");
                return;
            }
            if (this.serverProfile.getEnvironment() == null) {
                throw new MojoExecutionException("Apigee environment not found in profile");
            }
            String scope = "orgConfig";
            List resourcefiles = this.getOrgConfig(logger, "resourcefiles");
            if (resourcefiles == null || resourcefiles.size() == 0) {
                logger.info("No org scoped resourcefiles config found.");
            } else {
                this.doOrgUpdate(resourcefiles, scope);
            }
            resourcefiles = this.getEnvConfig(logger, "resourcefiles");
            if (resourcefiles == null || resourcefiles.size() == 0) {
                logger.info("No env scoped resourcefiles config found.");
            } else {
                this.doEnvUpdate(resourcefiles, scope);
            }
            Set<String> apis = this.getAPIList(logger);
            if (apis == null || apis.size() == 0) {
                logger.info("No API scoped Resource File config found.");
                return;
            }
            for (String api : apis) {
                resourcefiles = this.getAPIConfig(logger, "resourcefiles", api);
                if (resourcefiles == null || resourcefiles.size() == 0) {
                    logger.info("No API scoped resourcefiles config found for " + api);
                    continue;
                }
                this.doAPIUpdate(api, resourcefiles);
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String createOrgResourceFile(ServerProfile profile, String resourcefileType, String resourcefileName, String resourceFilePath) throws IOException {
        HttpResponse response = RestUtil.createOrgConfigUpload(profile, "resourcefiles?type=" + resourcefileType + "&name=" + resourcefileName, resourceFilePath);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("resourcefile create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String updateOrgResourceFile(ServerProfile profile, String resourcefileType, String resourcefileName, String resourcefilePath) throws IOException {
        HttpResponse response = RestUtil.updateOrgConfigUpload(profile, "resourcefiles", resourcefileType + "/" + resourcefileName, resourcefilePath);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("resourceFile update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteOrgResourceFile(ServerProfile profile, String resourcefileType, String resourcefileName) throws IOException {
        HttpResponse response = RestUtil.deleteOrgResourceFileConfig(profile, "resourcefiles", resourcefileType + "/" + resourcefileName);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("resourceFile delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String createEnvResourceFile(ServerProfile profile, String resourcefileType, String resourcefileName, String resourceFilePath) throws IOException {
        HttpResponse response = RestUtil.createEnvConfigUpload(profile, "resourcefiles?type=" + resourcefileType + "&name=" + resourcefileName, resourceFilePath);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("resourcefile create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String updateEnvResourceFile(ServerProfile profile, String resourcefileType, String resourcefileName, String resourcefilePath) throws IOException {
        HttpResponse response = RestUtil.updateEnvConfigUpload(profile, "resourcefiles", resourcefileType + "/" + resourcefileName, resourcefilePath);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("resourceFile update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteEnvResourceFile(ServerProfile profile, String resourcefileType, String resourcefileName) throws IOException {
        HttpResponse response = RestUtil.deleteEnvResourceFileConfig(profile, "resourcefiles", resourcefileType + "/" + resourcefileName);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("resourceFile delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getExistingResourceFile(ServerProfile profile, String scope, String api) throws IOException {
        HttpResponse response = null;
        if (scope != null && scope.equalsIgnoreCase("org")) {
            response = RestUtil.getOrgConfig(profile, "resourcefiles");
        } else if (scope != null && scope.equalsIgnoreCase("env")) {
            response = RestUtil.getEnvConfig(profile, "resourcefiles");
        } else if (scope != null && scope.equalsIgnoreCase("api")) {
            response = RestUtil.getAPIConfig(profile, api, "resourcefiles");
        }
        if (response == null) {
            return new ArrayList();
        }
        JSONArray resourcefilesArr = null;
        ArrayList<String> resourcefiles = new ArrayList<String>();
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(payload);
            resourcefilesArr = (JSONArray)obj1.get((Object)"resourceFile");
            if (resourcefilesArr != null && resourcefilesArr.size() > 0) {
                for (int i = 0; i < resourcefilesArr.size(); ++i) {
                    JSONObject resourcefile = (JSONObject)resourcefilesArr.get(i);
                    resourcefiles.add(resourcefile.get((Object)"name") + "_" + resourcefile.get((Object)"type"));
                }
            }
        }
        catch (ParseException pe) {
            logger.error("Get resourcefiles parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get resourcefiles error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return resourcefiles;
    }

    public static String createAPIResourceFile(ServerProfile serverProfile, String api, String revision, String resourcefileType, String resourcefileName, String resourcefilePath) throws IOException {
        HttpResponse response = RestUtil.createAPIConfigUpload(serverProfile, api, "revisions/" + revision + "/resourcefiles" + "?type=" + resourcefileType + "&name=" + resourcefileName, resourcefilePath);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Resource File create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String updateAPIResourceFile(ServerProfile profile, String api, String revision, String resourcefileType, String resourcefileName, String resourcefilePath) throws IOException {
        HttpResponse response = RestUtil.updateAPIConfigUpload(profile, api, "revisions/" + revision + "/resourcefiles", resourcefileType + "/" + resourcefileName, resourcefilePath);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Resource File update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteAPIResourceFile(ServerProfile profile, String api, String revision, String resourcefileType, String resourcefileName) throws IOException {
        HttpResponse response = RestUtil.deleteAPIResourceFileConfig(profile, api, "revisions/" + revision + "/resourcefiles", resourcefileType + "/" + resourcefileName);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Resource File delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static class ResourceFile {
        @Key
        public String name;
        @Key
        public String type;
        @Key
        public String file;
        @Key
        public String revision;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPTIONS {
        none,
        create,
        update,
        delete,
        sync;

    }
}

