/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin;

import com.apigee.edge.config.mavenplugin.GatewayAbstractMojo;
import com.apigee.edge.config.rest.RestUtil;
import com.apigee.edge.config.utils.ServerProfile;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.util.Key;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetServerMojo
extends GatewayAbstractMojo {
    static Logger logger = LoggerFactory.getLogger(TargetServerMojo.class);
    public static final String ____ATTENTION_MARKER____ = "************************************************************************";
    OPTIONS buildOption = OPTIONS.none;
    private ServerProfile serverProfile;

    public void init() throws MojoFailureException {
        try {
            logger.info(____ATTENTION_MARKER____);
            logger.info("Apigee Target Servers");
            logger.info(____ATTENTION_MARKER____);
            String options = "";
            this.serverProfile = super.getProfile();
            options = super.getOptions();
            if (options != null) {
                this.buildOption = OPTIONS.valueOf(options);
            }
            logger.debug("Build option " + this.buildOption.name());
            logger.debug("Base dir " + super.getBaseDirectoryPath());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid apigee.option provided");
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    protected String getTargetName(String payload) throws MojoFailureException {
        Gson gson = new Gson();
        try {
            TargetServer target = (TargetServer)gson.fromJson(payload, TargetServer.class);
            return target.name;
        }
        catch (JsonParseException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    protected void doUpdate(List<String> targets) throws MojoFailureException {
        try {
            List existingTargets = null;
            if (this.buildOption != OPTIONS.update && this.buildOption != OPTIONS.create && this.buildOption != OPTIONS.delete && this.buildOption != OPTIONS.sync) {
                return;
            }
            logger.info("Retrieving existing environment Target Servers - " + this.serverProfile.getEnvironment());
            existingTargets = TargetServerMojo.getTarget(this.serverProfile);
            for (String target : targets) {
                String targetName = this.getTargetName(target);
                if (targetName == null) {
                    throw new IllegalArgumentException("Target Server does not have a name.\n" + target + "\n");
                }
                if (existingTargets.contains(targetName)) {
                    switch (this.buildOption) {
                        case update: {
                            logger.info("Target Server \"" + targetName + "\" exists. Updating.");
                            TargetServerMojo.updateTarget(this.serverProfile, targetName, target);
                            break;
                        }
                        case create: {
                            logger.info("Target Server \"" + targetName + "\" already exists. Skipping.");
                            break;
                        }
                        case delete: {
                            logger.info("Target Server \"" + targetName + "\" already exists. Deleting.");
                            TargetServerMojo.deleteTarget(this.serverProfile, targetName);
                            break;
                        }
                        case sync: {
                            logger.info("Target Server \"" + targetName + "\" already exists. Deleting and recreating.");
                            TargetServerMojo.deleteTarget(this.serverProfile, targetName);
                            logger.info("Creating Target Server - " + targetName);
                            TargetServerMojo.createTarget(this.serverProfile, target);
                        }
                    }
                    continue;
                }
                switch (this.buildOption) {
                    case update: 
                    case create: 
                    case sync: {
                        logger.info("Creating Target Server - " + targetName);
                        TargetServerMojo.createTarget(this.serverProfile, target);
                        break;
                    }
                    case delete: {
                        logger.info("Target Server \"" + targetName + "\" does not exist. Skipping.");
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Apigee network call error " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (super.isSkip()) {
            this.getLog().info((CharSequence)"Skipping");
            return;
        }
        Logger logger = LoggerFactory.getLogger(TargetServerMojo.class);
        try {
            this.init();
            if (this.buildOption == OPTIONS.none) {
                logger.info("Skipping Target Servers (default action)");
                return;
            }
            if (this.serverProfile.getEnvironment() == null) {
                throw new MojoExecutionException("Apigee environment not found in profile");
            }
            List targets = this.getEnvConfig(logger, "targetServers");
            if (targets == null || targets.size() == 0) {
                logger.info("No target server config found.");
                return;
            }
            this.doUpdate(targets);
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String createTarget(ServerProfile profile, String target) throws IOException {
        HttpResponse response = RestUtil.createEnvConfig(profile, "targetservers", target);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Create Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Target Server create error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String updateTarget(ServerProfile profile, String targetName, String target) throws IOException {
        HttpResponse response = RestUtil.updateEnvConfig(profile, "targetservers", targetName, target);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Target Server update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static String deleteTarget(ServerProfile profile, String targetName) throws IOException {
        HttpResponse response = RestUtil.deleteEnvConfig(profile, "targetservers", targetName);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Delete Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("Target Server delete error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return "";
    }

    public static List getTarget(ServerProfile profile) throws IOException {
        HttpResponse response = RestUtil.getEnvConfig(profile, "targetservers");
        if (response == null) {
            return new ArrayList();
        }
        JSONArray targets = null;
        try {
            logger.debug("output " + response.getContentType());
            String payload = response.parseAsString();
            logger.debug(payload);
            String obj = "{ \"targets\": " + payload + "}";
            JSONParser parser = new JSONParser();
            JSONObject obj1 = (JSONObject)parser.parse(obj);
            targets = (JSONArray)obj1.get((Object)"targets");
        }
        catch (ParseException pe) {
            logger.error("Get Target Server parse error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Get Target Server error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return targets;
    }

    public static class TargetServer {
        @Key
        public String name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OPTIONS {
        none,
        create,
        update,
        delete,
        sync;

    }
}

