/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.mavenplugin.kvm;

import com.apigee.edge.config.mavenplugin.kvm.KvmValueObject;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import java.io.IOException;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KvmOperations {
    private static Logger logger = LoggerFactory.getLogger(KvmOperations.class);

    public abstract HttpResponse getEntriesForKvm(KvmValueObject var1, String var2) throws IOException;

    public abstract HttpResponse updateKvmEntries(KvmValueObject var1, String var2, String var3) throws IOException;

    public abstract HttpResponse updateKvmEntriesForNonCpsOrg(KvmValueObject var1) throws IOException;

    public abstract HttpResponse createKvmEntries(KvmValueObject var1, String var2) throws IOException;

    public void update(KvmValueObject kvmValueObject) throws IOException, MojoFailureException {
        if (this.isOrgCpsEnabled(kvmValueObject).booleanValue()) {
            this.updateKvmForCpsOrg(kvmValueObject);
        } else {
            this.updateKvmForNonCpsOrg(kvmValueObject);
        }
    }

    private Boolean isOrgCpsEnabled(KvmValueObject kvmValueObject) throws MojoFailureException {
        return kvmValueObject.getProfile().getCpsEnabled();
    }

    private void updateKvmForCpsOrg(KvmValueObject kvmValueObject) throws MojoFailureException, IOException {
        JSONArray entries = KvmOperations.getEntriesConfig(kvmValueObject.getKvm());
        for (Object entry : entries) {
            JSONObject entryJson = (JSONObject)entry;
            String entryName = (String)entryJson.get((Object)"name");
            HttpResponse response = this.doesEntryAlreadyExistForOrg(kvmValueObject, entryName) ? this.updateKvmEntries(kvmValueObject, entryName, entryJson.toJSONString()) : this.createKvmEntries(kvmValueObject, entryJson.toJSONString());
            try {
                logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
                if (!response.isSuccessStatusCode()) continue;
                logger.info("KVM Entry Update Success: " + entryName);
            }
            catch (HttpResponseException e) {
                logger.error("KVM update error " + e.getMessage());
                throw new IOException(e.getMessage());
            }
        }
        logger.info("KVM Update Success: " + kvmValueObject.getKvmName());
    }

    private void updateKvmForNonCpsOrg(KvmValueObject kvmValueObject) throws IOException {
        HttpResponse response = this.updateKvmEntriesForNonCpsOrg(kvmValueObject);
        try {
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                logger.info("Update Success.");
            }
        }
        catch (HttpResponseException e) {
            logger.error("KVM update error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    private static JSONArray getEntriesConfig(String kvm) throws MojoFailureException {
        JSONParser parser = new JSONParser();
        try {
            JSONObject entry = (JSONObject)parser.parse(kvm);
            return (JSONArray)entry.get((Object)"entry");
        }
        catch (ParseException ex) {
            logger.info(ex.getMessage());
            throw new MojoFailureException("Error parsing " + ex.getMessage());
        }
    }

    private boolean doesEntryAlreadyExistForOrg(KvmValueObject kvmValueObject, String kvmEntryName) {
        try {
            HttpResponse response = this.getEntriesForKvm(kvmValueObject, kvmEntryName);
            if (response == null) {
                return false;
            }
            logger.info("Response " + response.getContentType() + "\n" + response.parseAsString());
            if (response.isSuccessStatusCode()) {
                return true;
            }
        }
        catch (IOException e) {
            logger.error("Get KVM Entry error " + e.getMessage());
        }
        return false;
    }
}

