/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.rest;

import com.apigee.edge.config.rest.FakeHostnameVerifier;
import com.apigee.edge.config.rest.XTrustProvider;
import com.apigee.edge.config.utils.PrintUtil;
import com.apigee.edge.config.utils.ServerProfile;
import com.apigee.mgmtapi.sdk.client.MgmtAPIClient;
import com.apigee.mgmtapi.sdk.model.AccessToken;
import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.file.Files;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestUtil {
    static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    static final JsonFactory JSON_FACTORY = new JacksonFactory();
    static String versionRevision;
    static Logger logger;
    static String accessToken;
    static HttpRequestFactory REQUEST_FACTORY;

    public static HttpResponse createEnvConfig(ServerProfile profile, String resource, String payload) throws IOException {
        HttpResponse response;
        ByteArrayContent content = new ByteArrayContent("application/json", payload.getBytes());
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + resource;
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse createEnvConfig(ServerProfile profile, String resource, String resourceId, String subResource, String payload) throws IOException {
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8") + "/" + subResource;
        return RestUtil.executeAPIPost(profile, payload, importCmd);
    }

    public static HttpResponse createEnvConfigUpload(ServerProfile profile, String resource, String filePath) throws IOException {
        HttpResponse response;
        byte[] file = Files.readAllBytes(new File(filePath).toPath());
        ByteArrayContent content = new ByteArrayContent("application/octet-stream", file);
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + resource;
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse updateEnvConfig(ServerProfile profile, String resource, String resourceId, String payload) throws IOException {
        HttpResponse response;
        ByteArrayContent content = new ByteArrayContent("application/json", payload.getBytes());
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8");
        HttpRequest restRequest = REQUEST_FACTORY.buildPutRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse updateEnvConfig(ServerProfile profile, String resource, String resourceId, String subResource, String subResourceId, String payload) throws IOException {
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8") + "/" + subResource + "/" + subResourceId;
        return RestUtil.executeAPIPost(profile, payload, importCmd);
    }

    public static HttpResponse updateEnvConfigUpload(ServerProfile profile, String resource, String resourceId, String filePath) throws IOException {
        HttpResponse response;
        byte[] file = Files.readAllBytes(new File(filePath).toPath());
        ByteArrayContent content = new ByteArrayContent("application/octet-stream", file);
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + resource + "/" + resourceId;
        HttpRequest restRequest = REQUEST_FACTORY.buildPutRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse deleteEnvResourceFileConfig(ServerProfile profile, String resource, String resourceId) throws IOException {
        HttpResponse response;
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + resource + "/" + resourceId;
        HttpRequest restRequest = REQUEST_FACTORY.buildDeleteRequest(new GenericUrl(importCmd));
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse deleteEnvConfig(ServerProfile profile, String resource, String resourceId) throws IOException {
        return RestUtil.deleteEnvConfig(profile, resource, resourceId, null);
    }

    public static HttpResponse deleteEnvConfig(ServerProfile profile, String resource, String resourceId, String payload) throws IOException {
        HttpResponse response;
        HttpRequest restRequest;
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8");
        if (payload != null && !payload.equalsIgnoreCase("")) {
            ByteArrayContent content = new ByteArrayContent("application/json", payload.getBytes());
            restRequest = REQUEST_FACTORY.buildRequest(HttpMethod.DELETE, new GenericUrl(importCmd), (HttpContent)content);
        } else {
            restRequest = REQUEST_FACTORY.buildDeleteRequest(new GenericUrl(importCmd));
        }
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse getEnvConfig(ServerProfile profile, String resource) throws IOException {
        HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + resource));
        restRequest.setReadTimeout(0);
        HttpResponse response = null;
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse getEnvConfig(ServerProfile profile, String resource, String resourceId, String subResource, String subResourceId) throws IOException {
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/environments/" + profile.getEnvironment() + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8") + "/" + subResource + "/" + subResourceId;
        return RestUtil.executeAPIGet(profile, importCmd);
    }

    public static HttpResponse createOrgConfig(ServerProfile profile, String resource, String payload) throws IOException {
        HttpResponse response;
        ByteArrayContent content = new ByteArrayContent("application/json", payload.getBytes());
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + resource;
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse createOrgConfig(ServerProfile profile, String resource, String resourceId, String subResource, String payload) throws IOException {
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8") + "/" + subResource;
        return RestUtil.executeAPIPost(profile, payload, importCmd);
    }

    public static HttpResponse createOrgConfigUpload(ServerProfile profile, String resource, String filePath) throws IOException {
        HttpResponse response;
        byte[] file = Files.readAllBytes(new File(filePath).toPath());
        ByteArrayContent content = new ByteArrayContent("application/octet-stream", file);
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + resource;
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse updateOrgConfig(ServerProfile profile, String resource, String resourceId, String payload) throws IOException {
        HttpResponse response;
        ByteArrayContent content = new ByteArrayContent("application/json", payload.getBytes());
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8");
        HttpRequest restRequest = REQUEST_FACTORY.buildPutRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse updateOrgConfig(ServerProfile profile, String resource, String resourceId, String subResource, String subResourceId, String payload) throws IOException {
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8") + "/" + subResource + "/" + subResourceId;
        return RestUtil.executeAPIPost(profile, payload, importCmd);
    }

    public static HttpResponse updateOrgConfigUpload(ServerProfile profile, String resource, String resourceId, String filePath) throws IOException {
        HttpResponse response;
        byte[] file = Files.readAllBytes(new File(filePath).toPath());
        ByteArrayContent content = new ByteArrayContent("application/octet-stream", file);
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + resource + "/" + resourceId;
        HttpRequest restRequest = REQUEST_FACTORY.buildPutRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse deleteOrgConfig(ServerProfile profile, String resource, String resourceId) throws IOException {
        HttpResponse response;
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8");
        HttpRequest restRequest = REQUEST_FACTORY.buildDeleteRequest(new GenericUrl(importCmd));
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse deleteOrgResourceFileConfig(ServerProfile profile, String resource, String resourceId) throws IOException {
        HttpResponse response;
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + resource + "/" + resourceId;
        HttpRequest restRequest = REQUEST_FACTORY.buildDeleteRequest(new GenericUrl(importCmd));
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse getOrgConfig(ServerProfile profile, String resource) throws IOException {
        HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + resource));
        restRequest.setReadTimeout(0);
        HttpResponse response = null;
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse getOrgConfig(ServerProfile profile, String resource, String resourceId, String subResource, String subResourceId) throws IOException {
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8") + "/" + subResource + "/" + subResourceId;
        return RestUtil.executeAPIGet(profile, importCmd);
    }

    public static HttpResponse createAPIConfig(ServerProfile profile, String api, String resource, String payload) throws IOException {
        HttpResponse response;
        ByteArrayContent content = new ByteArrayContent("application/json", payload.getBytes());
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + api + "/" + resource;
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse createAPIConfig(ServerProfile profile, String api, String resource, String resourceId, String subResource, String payload) throws IOException {
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + api + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8") + "/" + subResource;
        return RestUtil.executeAPIPost(profile, payload, importCmd);
    }

    public static HttpResponse createAPIConfigUpload(ServerProfile profile, String api, String resource, String filePath) throws IOException {
        HttpResponse response;
        byte[] file = Files.readAllBytes(new File(filePath).toPath());
        ByteArrayContent content = new ByteArrayContent("application/octet-stream", file);
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + api + "/" + resource;
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse updateAPIConfig(ServerProfile profile, String api, String resource, String resourceId, String payload) throws IOException {
        HttpResponse response;
        ByteArrayContent content = new ByteArrayContent("application/json", payload.getBytes());
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + api + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8");
        HttpRequest restRequest = REQUEST_FACTORY.buildPutRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse updateAPIConfig(ServerProfile profile, String api, String resource, String resourceId, String subResource, String subResourceId, String payload) throws IOException {
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + api + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8") + "/" + subResource + "/" + subResourceId;
        return RestUtil.executeAPIPost(profile, payload, importCmd);
    }

    public static HttpResponse updateAPIConfigUpload(ServerProfile profile, String api, String resource, String resourceId, String filePath) throws IOException {
        HttpResponse response;
        byte[] file = Files.readAllBytes(new File(filePath).toPath());
        ByteArrayContent content = new ByteArrayContent("application/octet-stream", file);
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + api + "/" + resource + "/" + resourceId;
        HttpRequest restRequest = REQUEST_FACTORY.buildPutRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse deleteAPIConfig(ServerProfile profile, String api, String resource, String resourceId) throws IOException {
        HttpResponse response;
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + api + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8");
        HttpRequest restRequest = REQUEST_FACTORY.buildDeleteRequest(new GenericUrl(importCmd));
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse getAPIConfig(ServerProfile profile, String api, String resource) throws IOException {
        HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + api + "/" + resource));
        restRequest.setReadTimeout(0);
        HttpResponse response = null;
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            logger.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static HttpResponse getAPIConfig(ServerProfile profile, String api, String resource, String resourceId, String subResource, String subResourceId) throws IOException {
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + api + "/" + resource + "/" + URLEncoder.encode(resourceId, "UTF-8") + "/" + subResource + "/" + subResourceId;
        return RestUtil.executeAPIGet(profile, importCmd);
    }

    public static HttpResponse deleteAPIResourceFileConfig(ServerProfile profile, String api, String resource, String resourceId) throws IOException {
        HttpResponse response;
        String importCmd = profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/" + api + "/" + resource + "/" + resourceId;
        HttpRequest restRequest = REQUEST_FACTORY.buildDeleteRequest(new GenericUrl(importCmd));
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    public static void initMfa(ServerProfile profile) throws IOException {
        if (accessToken == null) {
            logger.info("=============Initialising MFA================");
            HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(profile.getHostUrl() + "/" + profile.getApi_version() + "/organizations/" + profile.getOrg() + "/apis/"));
            restRequest.setReadTimeout(0);
            try {
                HttpResponse response = RestUtil.executeAPI(profile, restRequest);
                logger.info("=============MFA Initialised================");
            }
            catch (HttpResponseException e) {
                logger.error(e.getMessage());
                throw e;
            }
        }
    }

    private static HttpResponse executeAPIGet(ServerProfile profile, String importCmd) throws IOException {
        HttpResponse response;
        HttpRequest restRequest = REQUEST_FACTORY.buildGetRequest(new GenericUrl(importCmd));
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    private static HttpResponse executeAPIPost(ServerProfile profile, String payload, String importCmd) throws IOException {
        HttpResponse response;
        ByteArrayContent content = new ByteArrayContent("application/json", payload.getBytes());
        HttpRequest restRequest = REQUEST_FACTORY.buildPostRequest(new GenericUrl(importCmd), (HttpContent)content);
        restRequest.setReadTimeout(0);
        try {
            response = RestUtil.executeAPI(profile, restRequest);
        }
        catch (HttpResponseException e) {
            logger.error("Apigee call failed " + e.getMessage());
            throw new IOException(e.getMessage());
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HttpResponse executeAPI(ServerProfile profile, HttpRequest request) throws IOException {
        block14: {
            String mgmtAPIClientSecret;
            String mgmtAPIClientId;
            String tokenUrl;
            String mfaToken;
            MgmtAPIClient client;
            HttpHeaders headers;
            block15: {
                headers = request.getHeaders();
                client = new MgmtAPIClient();
                mfaToken = profile.getMFAToken();
                tokenUrl = profile.getTokenUrl();
                mgmtAPIClientId = profile.getClientId() != null && !profile.getClientId().equalsIgnoreCase("") ? profile.getClientId() : "edgecli";
                mgmtAPIClientSecret = profile.getClientSecret() != null && !profile.getClientSecret().equalsIgnoreCase("") ? profile.getClientSecret() : "edgeclisecret";
                headers.setAccept("application/json");
                if (profile.getAuthType() != null && profile.getAuthType().equalsIgnoreCase("basic")) {
                    headers.setBasicAuthentication(profile.getCredential_user(), profile.getCredential_pwd());
                    logger.info(PrintUtil.formatRequest(request));
                    return request.execute();
                }
                if (profile.getBearerToken() == null || profile.getBearerToken().equalsIgnoreCase("")) break block15;
                String string = accessToken = accessToken != null ? accessToken : profile.getBearerToken();
                if (profile.getRefreshToken() != null && !profile.getRefreshToken().equalsIgnoreCase("")) {
                    if (RestUtil.isValidBearerToken(accessToken, profile, mgmtAPIClientId)) {
                        logger.info("Access Token valid");
                        headers.setAuthorization("Bearer " + accessToken);
                        break block14;
                    } else {
                        try {
                            AccessToken token = null;
                            logger.info("Access token not valid so acquiring new access token using Refresh Token");
                            token = client.getAccessTokenFromRefreshToken(tokenUrl, mgmtAPIClientId, mgmtAPIClientSecret, profile.getRefreshToken());
                            logger.info("New Access Token acquired");
                            accessToken = token.getAccess_token();
                            headers.setAuthorization("Bearer " + accessToken);
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage());
                            throw new IOException(e.getMessage());
                        }
                    }
                } else {
                    logger.info("Validating the access token passed");
                    if (!RestUtil.isValidBearerToken(profile.getBearerToken(), profile, mgmtAPIClientId)) {
                        logger.error("Access token not valid");
                        throw new IOException("Access token not valid");
                    }
                    logger.info("Access Token valid");
                    accessToken = profile.getBearerToken();
                    headers.setAuthorization("Bearer " + accessToken);
                }
                break block14;
            }
            if (accessToken != null) {
                logger.debug("Reusing mgmt API access token");
                headers.setAuthorization("Bearer " + accessToken);
            } else {
                logger.info("Acquiring mgmt API token from " + tokenUrl);
                try {
                    AccessToken token = null;
                    if (mfaToken == null || mfaToken.length() == 0) {
                        logger.info("MFA token not provided. Skipping.");
                        token = client.getAccessToken(tokenUrl, mgmtAPIClientId, mgmtAPIClientSecret, profile.getCredential_user(), profile.getCredential_pwd());
                    } else {
                        logger.info("Making use of the MFA token provided.");
                        token = client.getAccessToken(tokenUrl, mgmtAPIClientId, mgmtAPIClientSecret, profile.getCredential_user(), profile.getCredential_pwd(), profile.getMFAToken());
                    }
                    accessToken = token.getAccess_token();
                    headers.setAuthorization("Bearer " + accessToken);
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                    throw new IOException(e.getMessage());
                }
            }
        }
        logger.info(PrintUtil.formatRequest(request));
        return request.execute();
    }

    private static boolean isValidBearerToken(String accessToken, ServerProfile profile, String clientId) throws IOException {
        boolean isValid = false;
        try {
            JWT jwt = JWT.decode((String)accessToken);
            String jwtClientId = jwt.getClaim("client_id").asString();
            String jwtEmailId = jwt.getClaim("email").asString();
            long jwtExpiresAt = jwt.getExpiresAt().getTime() / 1000L;
            long difference = jwtExpiresAt - System.currentTimeMillis() / 1000L;
            if (jwt != null && jwtClientId != null && jwtClientId.equals(clientId) && jwtEmailId != null && jwtEmailId.equalsIgnoreCase(profile.getCredential_user()) && profile.getTokenUrl().contains(jwt.getIssuer()) && difference >= 30L) {
                isValid = true;
            }
        }
        catch (JWTDecodeException exception) {
            throw new IOException(exception.getMessage());
        }
        return isValid;
    }

    static {
        logger = LoggerFactory.getLogger(RestUtil.class);
        accessToken = null;
        REQUEST_FACTORY = HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)JSON_FACTORY.createJsonObjectParser());
                XTrustProvider.install();
                FakeHostnameVerifier _hostnameVerifier = new FakeHostnameVerifier();
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)((Object)_hostnameVerifier));
            }
        });
    }
}

