/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigReader {
    public static List getEnvConfig(String env, File configFile) throws ParseException, IOException {
        Logger logger = LoggerFactory.getLogger(ConfigReader.class);
        JSONParser parser = new JSONParser();
        ArrayList<String> out = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
            JSONArray configs = (JSONArray)parser.parse((Reader)bufferedReader);
            if (configs == null) {
                return null;
            }
            out = new ArrayList<String>();
            for (Object config : configs) {
                out.add(((JSONObject)config).toJSONString());
            }
        }
        catch (IOException ie) {
            logger.info(ie.getMessage());
            throw ie;
        }
        catch (ParseException pe) {
            logger.info(pe.getMessage());
            throw pe;
        }
        return out;
    }

    public static List getOrgConfig(File configFile) throws ParseException, IOException {
        Logger logger = LoggerFactory.getLogger(ConfigReader.class);
        JSONParser parser = new JSONParser();
        ArrayList<String> out = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
            JSONArray configs = (JSONArray)parser.parse((Reader)bufferedReader);
            if (configs == null) {
                return null;
            }
            out = new ArrayList<String>();
            for (Object config : configs) {
                out.add(((JSONObject)config).toJSONString());
            }
        }
        catch (IOException ie) {
            logger.info(ie.getMessage());
            throw ie;
        }
        catch (ParseException pe) {
            logger.info(pe.getMessage());
            throw pe;
        }
        return out;
    }

    public static Map<String, List<String>> getOrgConfigWithId(File configFile) throws ParseException, IOException {
        Logger logger = LoggerFactory.getLogger(ConfigReader.class);
        JSONParser parser = new JSONParser();
        HashMap<String, List<String>> out = null;
        ArrayList<String> outStrs = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
            Map sConfig = (Map)parser.parse((Reader)bufferedReader);
            if (sConfig == null) {
                return null;
            }
            Iterator it = sConfig.entrySet().iterator();
            out = new HashMap<String, List<String>>();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                JSONArray confs = (JSONArray)pair.getValue();
                outStrs = new ArrayList<String>();
                for (Object conf : confs) {
                    outStrs.add(((JSONObject)conf).toJSONString());
                }
                out.put((String)pair.getKey(), outStrs);
            }
        }
        catch (IOException ie) {
            logger.info(ie.getMessage());
            throw ie;
        }
        catch (ParseException pe) {
            logger.info(pe.getMessage());
            throw pe;
        }
        return out;
    }

    public static Set<String> getAPIList(String apiConfigDir) throws ParseException, IOException {
        Logger logger = LoggerFactory.getLogger(ConfigReader.class);
        HashSet<String> out = null;
        File[] files = new File(apiConfigDir).listFiles();
        if (files != null && files.length > 0) {
            out = new HashSet<String>();
            for (File file : files) {
                if (!file.isDirectory()) continue;
                out.add(file.getName());
            }
        }
        return out;
    }

    public static List getAPIConfig(File configFile) throws ParseException, IOException {
        Logger logger = LoggerFactory.getLogger(ConfigReader.class);
        JSONParser parser = new JSONParser();
        ArrayList<String> out = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
            JSONArray resourceConfigs = (JSONArray)parser.parse((Reader)bufferedReader);
            if (resourceConfigs == null) {
                return null;
            }
            out = new ArrayList<String>();
            for (Object config : resourceConfigs) {
                out.add(((JSONObject)config).toJSONString());
            }
        }
        catch (IOException ie) {
            logger.info(ie.getMessage());
            throw ie;
        }
        catch (ParseException pe) {
            logger.info(pe.getMessage());
            throw pe;
        }
        return out;
    }
}

