/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.utils;

import com.apigee.edge.config.utils.ConfigReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsolidatedConfigReader {
    public static List getEnvConfig(String env, File configFile, String scope, String resource) throws ParseException, IOException {
        Logger logger = LoggerFactory.getLogger(ConfigReader.class);
        JSONParser parser = new JSONParser();
        ArrayList<String> out = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
            JSONObject edgeConf = (JSONObject)parser.parse((Reader)bufferedReader);
            if (edgeConf == null) {
                return null;
            }
            JSONObject scopeConf = (JSONObject)edgeConf.get((Object)scope);
            if (scopeConf == null) {
                return null;
            }
            JSONObject envConf = (JSONObject)scopeConf.get((Object)env);
            if (envConf == null) {
                return null;
            }
            JSONArray configs = (JSONArray)envConf.get((Object)resource);
            if (configs == null) {
                return null;
            }
            out = new ArrayList<String>();
            for (Object config : configs) {
                out.add(((JSONObject)config).toJSONString());
            }
        }
        catch (IOException ie) {
            logger.info(ie.getMessage());
            throw ie;
        }
        catch (ParseException pe) {
            logger.info(pe.getMessage());
            throw pe;
        }
        return out;
    }

    public static List getOrgConfig(File configFile, String scope, String resource) throws ParseException, IOException {
        Logger logger = LoggerFactory.getLogger(ConfigReader.class);
        JSONParser parser = new JSONParser();
        ArrayList<String> out = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
            JSONObject edgeConf = (JSONObject)parser.parse((Reader)bufferedReader);
            if (edgeConf == null) {
                return null;
            }
            JSONObject scopeConf = (JSONObject)edgeConf.get((Object)scope);
            if (scopeConf == null) {
                return null;
            }
            JSONArray configs = (JSONArray)scopeConf.get((Object)resource);
            if (configs == null) {
                return null;
            }
            out = new ArrayList<String>();
            for (Object config : configs) {
                out.add(((JSONObject)config).toJSONString());
            }
        }
        catch (IOException ie) {
            logger.info(ie.getMessage());
            throw ie;
        }
        catch (ParseException pe) {
            logger.info(pe.getMessage());
            throw pe;
        }
        return out;
    }

    public static Map<String, List<String>> getOrgConfigWithId(File configFile, String scope, String resource) throws ParseException, IOException {
        Logger logger = LoggerFactory.getLogger(ConfigReader.class);
        JSONParser parser = new JSONParser();
        HashMap<String, List<String>> out = null;
        ArrayList<String> outStrs = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
            JSONObject edgeConf = (JSONObject)parser.parse((Reader)bufferedReader);
            if (edgeConf == null) {
                return null;
            }
            JSONObject scopeConf = (JSONObject)edgeConf.get((Object)scope);
            if (scopeConf == null) {
                return null;
            }
            Map sConfig = (Map)scopeConf.get((Object)resource);
            if (sConfig == null) {
                return null;
            }
            Iterator it = sConfig.entrySet().iterator();
            out = new HashMap<String, List<String>>();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                JSONArray confs = (JSONArray)pair.getValue();
                outStrs = new ArrayList<String>();
                for (Object conf : confs) {
                    outStrs.add(((JSONObject)conf).toJSONString());
                }
                out.put((String)pair.getKey(), outStrs);
            }
        }
        catch (IOException ie) {
            logger.info(ie.getMessage());
            throw ie;
        }
        catch (ParseException pe) {
            logger.info(pe.getMessage());
            throw pe;
        }
        return out;
    }

    public static Set<String> getAPIList(File configFile) throws ParseException, IOException {
        Logger logger = LoggerFactory.getLogger(ConfigReader.class);
        JSONParser parser = new JSONParser();
        Object out = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
            JSONObject edgeConf = (JSONObject)parser.parse((Reader)bufferedReader);
            if (edgeConf == null) {
                return null;
            }
            JSONObject scopeConf = (JSONObject)edgeConf.get((Object)"apiConfig");
            if (scopeConf == null) {
                return null;
            }
            return scopeConf.keySet();
        }
        catch (IOException ie) {
            logger.info(ie.getMessage());
            throw ie;
        }
        catch (ParseException pe) {
            logger.info(pe.getMessage());
            throw pe;
        }
    }

    public static List getAPIConfig(File configFile, String api, String resource) throws ParseException, IOException {
        Logger logger = LoggerFactory.getLogger(ConfigReader.class);
        JSONParser parser = new JSONParser();
        ArrayList<String> out = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(configFile));
            JSONObject edgeConf = (JSONObject)parser.parse((Reader)bufferedReader);
            if (edgeConf == null) {
                return null;
            }
            JSONObject scopeConf = (JSONObject)edgeConf.get((Object)"apiConfig");
            if (scopeConf == null) {
                return null;
            }
            JSONObject scopedConfigs = (JSONObject)scopeConf.get((Object)api);
            if (scopedConfigs == null) {
                return null;
            }
            JSONArray resourceConfigs = (JSONArray)scopedConfigs.get((Object)resource);
            if (resourceConfigs == null) {
                return null;
            }
            out = new ArrayList<String>();
            for (Object config : resourceConfigs) {
                out.add(((JSONObject)config).toJSONString());
            }
        }
        catch (IOException ie) {
            logger.info(ie.getMessage());
            throw ie;
        }
        catch (ParseException pe) {
            logger.info(pe.getMessage());
            throw pe;
        }
        return out;
    }
}

