/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.edge.config.utils;

import com.apigee.edge.config.rest.RestUtil;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import java.io.IOException;
import java.util.HashMap;
import org.apache.maven.plugin.MojoFailureException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerProfile {
    private static Logger logger = LoggerFactory.getLogger(ServerProfile.class);
    private String application;
    private String org;
    private String credential_user;
    private String credential_pwd;
    private String hostURL;
    private String environment;
    private String api_version;
    private String bundle_zip_full_path;
    private String profileId;
    private String options;
    private Boolean cpsEnabled;
    private String tokenURL;
    private String mfaToken;
    private String clientId;
    private String clientSecret;
    private String bearerToken;
    private String refreshToken;
    private String authType;

    public String getHostURL() {
        return this.hostURL;
    }

    public void setHostURL(String hostURL) {
        this.hostURL = hostURL;
    }

    public String getTokenUrl() {
        return this.tokenURL;
    }

    public void setTokenUrl(String tokenURL) {
        this.tokenURL = tokenURL;
    }

    public String getMFAToken() {
        return this.mfaToken;
    }

    public void setMFAToken(String mfaToken) {
        this.mfaToken = mfaToken;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getCredential_user() {
        return this.credential_user;
    }

    public void setCredential_user(String credential_user) {
        this.credential_user = credential_user;
    }

    public String getCredential_pwd() {
        return this.credential_pwd;
    }

    public void setCredential_pwd(String credential_pwd) {
        this.credential_pwd = credential_pwd;
    }

    public String getHostUrl() {
        return this.hostURL;
    }

    public void setHostUrl(String host) {
        this.hostURL = host;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getApi_version() {
        return this.api_version;
    }

    public void setApi_version(String api_version) {
        this.api_version = api_version;
    }

    public String getBundle_zip_full_path() {
        return this.bundle_zip_full_path;
    }

    public void setBundle_zip_full_path(String bundle_zip_full_path) {
        this.bundle_zip_full_path = bundle_zip_full_path;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String id) {
        this.profileId = id;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public Boolean getCpsEnabled() throws MojoFailureException {
        if (this.cpsEnabled == null) {
            try {
                HashMap<String, String> features = this.queryOrgFeatures(this);
                this.cpsEnabled = features != null && features.get("features.isCpsEnabled") != null && features.get("features.isCpsEnabled").equals("true") ? new Boolean(true) : new Boolean(false);
            }
            catch (Exception e) {
                throw new MojoFailureException("Error finding org features. Check if user can access /organizations");
            }
        }
        return this.cpsEnabled;
    }

    private HashMap<String, String> queryOrgFeatures(ServerProfile profile) throws IOException {
        HttpResponse response = RestUtil.getOrgConfig(profile, "");
        try {
            assert (response != null);
            logger.debug("response Get Organization: " + response.getContentType());
            String jsonRespnse = response.parseAsString();
            logger.debug(jsonRespnse);
            JSONParser parser = new JSONParser();
            JSONObject jsonPayload = (JSONObject)parser.parse(jsonRespnse);
            JSONObject properties = (JSONObject)jsonPayload.get((Object)"properties");
            if (properties == null) {
                return null;
            }
            JSONArray property = (JSONArray)properties.get((Object)"property");
            if (property == null) {
                return null;
            }
            HashMap<String, String> organizationProfileMap = new HashMap<String, String>();
            for (Object obj : property) {
                JSONObject feature = (JSONObject)obj;
                String name = (String)feature.get((Object)"name");
                String value = (String)feature.get((Object)"value");
                if (name == null) continue;
                organizationProfileMap.put(name, value);
            }
            return organizationProfileMap;
        }
        catch (ParseException pe) {
            logger.error("Org properties check error " + pe.getMessage());
            throw new IOException(pe.getMessage());
        }
        catch (HttpResponseException e) {
            logger.error("Org properties check error " + e.getMessage());
            throw new IOException(e.getMessage());
        }
    }
}

