/*
 * Decompiled with CFR 0.152.
 */
package com.apigee.mgmtapi.sdk.client;

import com.apigee.mgmtapi.sdk.core.AppConfig;
import com.apigee.mgmtapi.sdk.model.AccessToken;
import com.apigee.mgmtapi.sdk.service.FileService;
import com.google.gson.Gson;
import java.nio.charset.Charset;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class MgmtAPIClient {
    private static final Logger logger = Logger.getLogger(MgmtAPIClient.class);

    public AccessToken getAccessToken(String username, String password) throws Exception {
        Environment env = this.getConfigProperties();
        if (env == null) {
            logger.error((Object)"Config file missing");
            throw new Exception("Config file missing");
        }
        return this.getAccessToken(env.getProperty("mgmt.login.url"), env.getProperty("mgmt.login.client.id"), env.getProperty("mgmt.login.client.secret"), username, password);
    }

    public AccessToken getAccessToken(String username, String password, String mfa) throws Exception {
        Environment env = this.getConfigProperties();
        if (env == null) {
            logger.error((Object)"Config file missing");
            throw new Exception("Config file missing");
        }
        if (mfa == null || mfa.equals("")) {
            logger.error((Object)"mfa cannot be empty");
            throw new Exception("mfa cannot be empty");
        }
        return this.getAccessToken(env.getProperty("mgmt.login.mfa.url") + mfa, env.getProperty("mgmt.login.client.id"), env.getProperty("mgmt.login.client.secret"), username, password);
    }

    public AccessToken getAccessToken(String url, String clientId, String client_secret, String username, String password, String mfa) throws Exception {
        return this.getAccessToken(url + "?mfa_token=" + mfa, clientId, client_secret, username, password);
    }

    public AccessToken getAccessToken(String url, String clientId, String client_secret, String username, String password) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        AccessToken token = new AccessToken();
        ResponseEntity result = null;
        try {
            headers.add("Authorization", "Basic " + new String(Base64.encode((byte[])(clientId + ":" + client_secret).getBytes()), Charset.forName("UTF-8")));
            headers.add("Content-Type", "application/x-www-form-urlencoded");
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"username", (Object)username);
            map.add((Object)"password", (Object)password);
            map.add((Object)"grant_type", (Object)"password");
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            result = restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            if (result.getStatusCode().equals((Object)HttpStatus.OK)) {
                Gson gson = new Gson();
                token = (AccessToken)gson.fromJson((String)result.getBody(), AccessToken.class);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
        return token;
    }

    public AccessToken getAccessTokenFromRefreshToken(String url, String clientId, String client_secret, String refreshToken) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        AccessToken token = new AccessToken();
        ResponseEntity result = null;
        try {
            headers.add("Authorization", "Basic " + new String(Base64.encode((byte[])(clientId + ":" + client_secret).getBytes()), Charset.forName("UTF-8")));
            headers.add("Content-Type", "application/x-www-form-urlencoded");
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            map.add((Object)"refresh_token", (Object)refreshToken);
            map.add((Object)"grant_type", (Object)"refresh_token");
            HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
            result = restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            if (result.getStatusCode().equals((Object)HttpStatus.OK)) {
                Gson gson = new Gson();
                token = (AccessToken)gson.fromJson((String)result.getBody(), AccessToken.class);
            }
        }
        catch (Exception e) {
            logger.error((Object)("Refresh Token could be invalid or expired: " + e.getMessage()));
            throw e;
        }
        return token;
    }

    public Environment getConfigProperties() {
        FileService service = null;
        try {
            if (System.getProperty("configFile.path") == null || System.getProperty("configFile.path").equalsIgnoreCase("")) {
                return null;
            }
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{AppConfig.class});
            service = (FileService)context.getBean("fileService");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return service.getEnvironment();
    }
}

